/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.criterion.SitOnBlockCriterion;
import juuxel.adorn.entity.AdornEntities;
import juuxel.adorn.entity.SeatEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public abstract class SeatBlock
extends class_2248 {
    public static final class_2746 OCCUPIED = class_2741.field_12528;

    public SeatBlock(class_4970.class_2251 settings) {
        super(settings);
        if (this.isSittingEnabled()) {
            this.method_9590((class_2680)this.method_9564().method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    public abstract class_2960 getSittingStat();

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2680 actualState;
        if (!this.isSittingEnabled()) {
            return super.method_55766(state, world, pos, player, hit);
        }
        class_2338 actualPos = this.getActualSeatPos(world, state, pos);
        class_2680 class_26802 = actualState = pos.equals((Object)actualPos) ? state : world.method_8320(actualPos);
        if (state != actualState && !(actualState.method_26204() instanceof SeatBlock)) {
            return class_1269.field_5811;
        }
        Boolean occupied = (Boolean)actualState.method_11654((class_2769)OCCUPIED);
        if (!occupied.booleanValue()) {
            if (!world.field_9236) {
                SeatEntity entity = new SeatEntity((class_1299)AdornEntities.SEAT.get(), world);
                entity.setPos(actualPos);
                world.method_8649((class_1297)entity);
                world.method_8501(actualPos, (class_2680)actualState.method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(true)));
                player.method_5873((class_1297)entity, true);
                class_2960 sittingStat = this.getSittingStat();
                if (sittingStat != null) {
                    player.method_7281(sittingStat);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    ((SitOnBlockCriterion)((Object)AdornCriteria.SIT_ON_BLOCK.get())).trigger(serverPlayer, pos);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        if (this.isSittingEnabled()) {
            List seats = world.method_18023((class_5575)AdornEntities.SEAT.get(), new class_238(this.getActualSeatPos((class_1937)world, state, pos)), (Predicate)Predicates.alwaysTrue());
            for (SeatEntity seat : seats) {
                seat.method_31472();
            }
        }
    }

    protected class_2338 getActualSeatPos(class_1937 world, class_2680 state, class_2338 pos) {
        return pos;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        if (this.isSittingEnabled()) {
            builder.method_11667(new class_2769[]{OCCUPIED});
        }
    }

    protected boolean isSittingEnabled() {
        return true;
    }

    public double getSittingOffset(class_1937 world, class_2680 state, class_2338 pos) {
        return state.method_26220((class_1922)world, pos).method_1105(class_2350.class_2351.field_11052);
    }

    public class_2350 getPreferredDismountDirection(class_2680 state, class_1297 passenger) {
        return passenger.method_5735();
    }
}

