/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import juuxel.adorn.block.entity.BrewerBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.util.FluidStorageReference;
import juuxel.adorn.util.NbtUtil;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class BrewerBlockEntityFabric
extends BrewerBlockEntity {
    private static final String NBT_FLUID = "Fluid";
    private static final String NBT_VOLUME = "Volume";
    private final SingleVariantStorage<FluidVariant> fluidStorage = new SingleVariantStorage<FluidVariant>(){

        protected long getCapacity(FluidVariant variant) {
            return 162000L;
        }

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected void onFinalCommit() {
            BrewerBlockEntityFabric.this.method_5431();
        }
    };
    private final FluidReference fluidReference = new FluidStorageReference(this.fluidStorage);

    public BrewerBlockEntityFabric(class_2338 pos, class_2680 state) {
        super(pos, state);
    }

    public SingleVariantStorage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    @Override
    public FluidReference getFluidReference() {
        return this.fluidReference;
    }

    @Override
    protected boolean canExtractFluidContainer() {
        try (Transaction transaction = Transaction.openOuter();){
            boolean bl = this.extractFluidContainer((TransactionContext)transaction) == 0L;
            return bl;
        }
    }

    @Override
    protected void tryExtractFluidContainer() {
        this.extractFluidContainer(null);
    }

    private long extractFluidContainer(@Nullable TransactionContext transaction) {
        SingleSlotStorage fluidContainerSlot = InventoryStorage.of((class_1263)this, null).getSlot(3);
        Storage itemStorage = (Storage)FluidStorage.ITEM.find(this.method_5438(3), (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)fluidContainerSlot));
        return StorageUtil.move((Storage)itemStorage, this.fluidStorage, (Predicate)Predicates.alwaysTrue(), (long)Long.MAX_VALUE, (TransactionContext)transaction);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        NbtUtil.putWithCodec(nbt, NBT_FLUID, FluidVariant.CODEC, (FluidVariant)this.fluidStorage.variant, registries);
        nbt.method_10544(NBT_VOLUME, this.fluidStorage.amount);
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.fluidStorage.variant = (TransferVariant)NbtUtil.getWithCodec(nbt, NBT_FLUID, FluidVariant.CODEC, registries);
        this.fluidStorage.amount = nbt.method_68080(NBT_VOLUME, 0L);
    }
}

