/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.client.gui.screen.AdornMenuScreen;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.Logging;
import net.minecraft.class_1058;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public final class BrewerScreen
extends AdornMenuScreen<BrewerMenu> {
    private static final Logger LOGGER = Logging.logger();
    public static final class_2960 TEXTURE = AdornCommon.id("textures/gui/brewer.png");
    public static final int FLUID_AREA_HEIGHT = 59;

    public BrewerScreen(BrewerMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25290(class_1921::method_62277, TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        BrewerScreen.drawFluid(context, this.field_2776 + 145, this.field_2800 + 17, ((BrewerMenu)this.field_2797).getFluid());
        context.method_25290(class_1921::method_62277, TEXTURE, this.field_2776 + 145, this.field_2800 + 21, 176.0f, 25.0f, 16, 51, 256, 256);
        int progress = ((BrewerMenu)this.field_2797).getProgress();
        if (progress > 0) {
            float progressFract = (float)progress / 200.0f;
            context.method_25290(class_1921::method_62277, TEXTURE, this.field_2776 + 84, this.field_2800 + 24, 176.0f, 0.0f, 8, class_3532.method_15386((float)(progressFract * 25.0f)), 256, 256);
        }
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        int x2 = x - this.field_2776;
        int y2 = y - this.field_2800;
        if (145 <= x2 && x2 < 161 && 17 <= y2 && y2 < 76) {
            context.method_51434(this.field_22793, this.getFluidTooltip(((BrewerMenu)this.field_2797).getFluid()), x, y);
        }
    }

    private List<class_2561> getFluidTooltip(FluidReference fluid) {
        return FluidRenderingBridge.get().getTooltip(fluid, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070), 2000);
    }

    public static void setFluidFromPacket(class_310 client, int syncId, FluidVolume fluid) {
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_3936) {
            class_3936 menuProvider = (class_3936)class_4372;
            class_1703 menu = menuProvider.method_17577();
            if (menu.field_7763 == syncId && menu instanceof BrewerMenu) {
                BrewerMenu brewerMenu = (BrewerMenu)menu;
                brewerMenu.setFluid(fluid);
            }
        }
    }

    private static void drawSprite(class_332 context, int x, float y, float width, float height, float u0, float v0, float u1, float v1, class_1058 sprite, int color) {
        Matrix4f positionMatrix = context.method_51448().method_23760().method_23761();
        float au0 = class_3532.method_16439((float)u0, (float)sprite.method_4594(), (float)sprite.method_4577());
        float au1 = class_3532.method_16439((float)u1, (float)sprite.method_4594(), (float)sprite.method_4577());
        float av0 = class_3532.method_16439((float)v0, (float)sprite.method_4593(), (float)sprite.method_4575());
        float av1 = class_3532.method_16439((float)v1, (float)sprite.method_4593(), (float)sprite.method_4575());
        class_1921 renderLayer = class_1921.method_62277((class_2960)sprite.method_45852());
        class_4588 buffer = context.field_44658.getBuffer(renderLayer);
        buffer.method_22918(positionMatrix, (float)x, y + height, 0.0f).method_22913(au0, av1).method_39415(color);
        buffer.method_22918(positionMatrix, (float)x + width, y + height, 0.0f).method_22913(au1, av1).method_39415(color);
        buffer.method_22918(positionMatrix, (float)x + width, y, 0.0f).method_22913(au1, av0).method_39415(color);
        buffer.method_22918(positionMatrix, (float)x, y, 0.0f).method_22913(au0, av0).method_39415(color);
    }

    public static void drawFluid(class_332 context, int x, int y, FluidReference fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        FluidRenderingBridge bridge = FluidRenderingBridge.get();
        class_1058 sprite = bridge.getStillSprite(fluid);
        if (sprite == null) {
            LOGGER.warn("Could not find sprite for {} in brewer screen", (Object)fluid);
            return;
        }
        int color = Colors.color(bridge.getColor(fluid));
        float height = 59.0f * ((float)fluid.getAmount() / (float)(2L * fluid.getUnit().getBucketVolume()));
        int fluidY = 0;
        int tiles = class_3532.method_15375((float)(height / 16.0f));
        for (int i = 0; i < tiles; ++i) {
            BrewerScreen.drawSprite(context, x, (float)y + BrewerScreen.transformY(bridge, fluid, fluidY, 16.0f), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, sprite, color);
            fluidY += 16;
        }
        float leftover = height % 16.0f;
        BrewerScreen.drawSprite(context, x, (float)y + BrewerScreen.transformY(bridge, fluid, fluidY, leftover), 16.0f, leftover, 0.0f, 0.0f, 1.0f, leftover / 16.0f, sprite, color);
    }

    private static float transformY(FluidRenderingBridge bridge, FluidReference fluid, int fluidY, float areaHeight) {
        if (bridge.fillsFromTop(fluid)) {
            return fluidY;
        }
        return (float)(59 - fluidY) - areaHeight;
    }
}

