/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.resources;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.resources.ColorPalette;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.Logging;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.slf4j.Logger;

public class ColorManager
extends class_4080<Map<class_2960, List<JsonObject>>> {
    public static final class_2960 ID = AdornCommon.id("color_manager");
    private static final Logger LOGGER = Logging.logger();
    private static final class_2960 FALLBACK = AdornCommon.id("fallback");
    private static final String PREFIX = "adorn/color_palettes";
    private static final Pattern COLOR_REGEX = Pattern.compile("^#(?:[0-9A-Fa-f]{2})?[0-9A-Fa-f]{6}$");
    private static final Codec<Map<class_2960, ColorPair>> PALETTE_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, ColorPair.CODEC);
    private final Map<class_2960, ColorPalette> palettes = new HashMap<class_2960, ColorPalette>();

    protected Map<class_2960, List<JsonObject>> prepare(class_3300 manager, class_3695 profiler) {
        Gson gson = new Gson();
        class_7654 resourceFinder = class_7654.method_45114((String)PREFIX);
        HashMap<class_2960, List<JsonObject>> result = new HashMap<class_2960, List<JsonObject>>();
        for (Map.Entry entry : resourceFinder.method_45116(manager).entrySet()) {
            class_2960 id = resourceFinder.method_45115((class_2960)entry.getKey());
            ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
            result.put(id, jsons);
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader in = resource.method_43039();
                    try {
                        jsons.add((JsonObject)gson.fromJson((Reader)in, JsonObject.class));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("[Adorn] Could not load color palette resource {} from {}", new Object[]{entry.getKey(), resource.method_14480(), e});
                }
            }
        }
        return result;
    }

    protected void apply(Map<class_2960, List<JsonObject>> prepared, class_3300 manager, class_3695 profiler) {
        this.palettes.clear();
        prepared.forEach((id, jsons) -> {
            HashMap<class_2960, ColorPair> palette = new HashMap<class_2960, ColorPair>();
            Iterator iterator = jsons.iterator();
            block7: while (true) {
                DataResult selector1$temp;
                if (!iterator.hasNext()) {
                    this.palettes.put((class_2960)id, new ColorPalette(palette));
                    return;
                }
                JsonObject json = (JsonObject)iterator.next();
                Objects.requireNonNull(PALETTE_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json));
                int index$2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector1$temp, index$2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Map partialPalette;
                        DataResult.Success $b$0 = (DataResult.Success)selector1$temp;
                        try {
                            Map patt3$temp;
                            partialPalette = patt3$temp = (Map)$b$0.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        {
                            Lifecycle patt4$temp;
                            Lifecycle lifecycle = patt4$temp = $b$0.lifecycle();
                            palette.putAll(partialPalette);
                            continue block7;
                        }
                    }
                    case 1: 
                }
                DataResult.Error error = (DataResult.Error)selector1$temp;
                LOGGER.error("[Adorn] Could not parse color palette {}: {}", id, (Object)error.message());
            }
        });
    }

    public ColorPalette getColors(class_2960 id) {
        ColorPalette pair = this.palettes.get(id);
        if (pair == null && (pair = this.palettes.get(FALLBACK)) == null) {
            throw new IllegalStateException("Could not find fallback palette!");
        }
        return pair;
    }

    private static DataResult<Integer> parseHexColor(String str) {
        if (!COLOR_REGEX.matcher(str).matches()) {
            return DataResult.error(() -> "Color must be a hex color beginning with '#' - found " + str);
        }
        String colorStr = str.substring(1);
        return DataResult.success((Object)(switch (colorStr.length()) {
            case 6 -> Colors.color(Integer.parseInt(colorStr, 16));
            case 8 -> Integer.parseInt(colorStr, 16);
            default -> throw new MatchException("Mismatching color length: " + colorStr.length(), null);
        }));
    }

    private static String writeHexColor(int color) {
        String hex = HexFormat.of().withUpperCase().toHexDigits(color);
        return "#" + (hex.startsWith("00") ? hex.substring(2) : hex);
    }

    public record ColorPair(int bg, int fg) {
        private static final int DEFAULT_FG = -12566464;
        private static final Codec<Integer> COLOR_CODEC = Codec.STRING.comapFlatMap(ColorManager::parseHexColor, ColorManager::writeHexColor);
        public static final Codec<ColorPair> CODEC = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)COLOR_CODEC.fieldOf("bg").forGetter(ColorPair::bg), (App)COLOR_CODEC.optionalFieldOf("fg", (Object)-12566464).forGetter(ColorPair::fg)).apply((Applicative)instance, ColorPair::new)), (Codec)COLOR_CODEC.xmap(bg -> new ColorPair((int)bg, -12566464), ColorPair::bg)).xmap(Either::unwrap, pair -> pair.fg == -12566464 ? Either.right((Object)pair) : Either.left((Object)pair));
    }
}

