/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.fluid.FluidAmountPredicate;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.HasFluidAmount;

public final class StepMaximum
implements FluidAmountPredicate {
    private final long min;
    private final long max;
    private final long step;
    private final FluidUnit unit;
    private final HasFluidAmount upperBound;

    public StepMaximum(long min, long max, long step, FluidUnit unit) {
        if (min >= max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        if ((max - min) % step != 0L) {
            throw new IllegalArgumentException("max - min must be divisible by step");
        }
        this.min = min;
        this.max = max;
        this.step = step;
        this.unit = unit;
        this.upperBound = new HasFluidAmount(){

            @Override
            public long getAmount() {
                return StepMaximum.this.max;
            }

            @Override
            public FluidUnit getUnit() {
                return StepMaximum.this.unit;
            }
        };
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getStep() {
        return this.step;
    }

    public FluidUnit getUnit() {
        return this.unit;
    }

    @Override
    public HasFluidAmount getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean test(long amount, FluidUnit unit) {
        long toCompare = FluidUnit.convert(amount, unit, this.unit);
        if (toCompare < this.min || toCompare > this.max) {
            return false;
        }
        long zeroed = toCompare - this.min;
        return zeroed % this.step == 0L;
    }
}

