/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;

public final class CollectionUtil {
    public static <E> List<E> interleave(List<List<E>> lists) {
        int size = CollectionUtil.sumOf(lists, List::size);
        int maxSize = CollectionUtil.maxOf(lists, List::size);
        ArrayList<E> output = new ArrayList<E>(size);
        for (int i = 0; i < maxSize; ++i) {
            for (List<E> list : lists) {
                if (i >= list.size()) continue;
                output.add(list.get(i));
            }
        }
        return output;
    }

    public static <T> int sumOf(Iterable<T> ts, ToIntFunction<? super T> getter) {
        int sum = 0;
        for (T t : ts) {
            sum += getter.applyAsInt(t);
        }
        return sum;
    }

    public static <T> int maxOf(Iterable<T> ts, ToIntFunction<? super T> getter) {
        int max = Integer.MIN_VALUE;
        for (T t : ts) {
            int current = getter.applyAsInt(t);
            if (current <= max) continue;
            max = current;
        }
        return max;
    }
}

