/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.block.property.OptionalProperty;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5815;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public abstract class CarpetedBlock
extends SeatBlock {
    public static final OptionalProperty<class_1767> CARPET = new OptionalProperty(class_2754.method_11850((String)"carpet", class_1767.class));
    public static final class_265 CARPET_SHAPE = CarpetedBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final Map<class_1767, class_2248> COLORS_TO_BLOCKS = new EnumMap<class_1767, class_2248>(class_1767.class);

    public CarpetedBlock(class_4970.class_2251 settings) {
        super(settings);
        if (this.isCarpetingEnabled()) {
            this.method_9590((class_2680)this.method_9564().method_11657(CARPET, CARPET.getNone()));
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        if (this.isCarpetingEnabled()) {
            builder.method_11667(new class_2769[]{CARPET});
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        if (this.isCarpetingEnabled()) {
            return (class_2680)super.method_9605(ctx).method_11657(CARPET, CARPET.wrapOrNone(CarpetedBlock.getCarpetColor(ctx)));
        }
        return super.method_9605(ctx);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2248 carpetBlock;
        if (!this.isCarpetingEnabled()) {
            return;
        }
        OptionalProperty.Value carpet = (OptionalProperty.Value)state.method_11654(CARPET);
        if (carpet.isPresent() && !(carpetBlock = COLORS_TO_BLOCKS.get(carpet.value())).method_9564().method_26184((class_4538)world, pos)) {
            carpetBlock.method_9576((class_1937)world, pos, state, null);
            CarpetedBlock.method_9497((class_2680)carpetBlock.method_9564(), (class_1937)world, (class_2338)pos);
            world.method_8501(pos, (class_2680)state.method_11657(CARPET, CARPET.getNone()));
        }
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        OptionalProperty.Value carpet;
        if (this.isCarpetingEnabled() && (carpet = (OptionalProperty.Value)state.method_11654(CARPET)).isPresent() && !COLORS_TO_BLOCKS.get(carpet.value()).method_9564().method_26184(world, pos)) {
            tickView.method_64310(pos, (class_2248)this, 1);
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        if (this.isCarpetingEnabled() && ((OptionalProperty.Value)state.method_11654(CARPET)).isPresent()) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>(super.method_9560(state, builder));
            stacks.addAll(COLORS_TO_BLOCKS.get(((OptionalProperty.Value)state.method_11654(CARPET)).value()).method_9564().method_26189(builder));
            return stacks;
        }
        return super.method_9560(state, builder);
    }

    public boolean isCarpetingEnabled() {
        return true;
    }

    public boolean canStateBeCarpeted(class_2680 state) {
        return this.isCarpetingEnabled() && state.method_11654(CARPET) == CARPET.getNone();
    }

    @Nullable
    private static class_1767 getCarpetColor(class_1750 context) {
        class_1767 class_17672;
        class_2248 block = context.method_8045().method_8320(context.method_8037()).method_26204();
        if (block instanceof class_5815) {
            class_5815 carpet = (class_5815)block;
            class_17672 = carpet.method_33635();
        } else {
            class_17672 = null;
        }
        return class_17672;
    }

    static {
        COLORS_TO_BLOCKS.put(class_1767.field_7952, class_2246.field_10466);
        COLORS_TO_BLOCKS.put(class_1767.field_7946, class_2246.field_9977);
        COLORS_TO_BLOCKS.put(class_1767.field_7958, class_2246.field_10482);
        COLORS_TO_BLOCKS.put(class_1767.field_7951, class_2246.field_10290);
        COLORS_TO_BLOCKS.put(class_1767.field_7947, class_2246.field_10512);
        COLORS_TO_BLOCKS.put(class_1767.field_7961, class_2246.field_10040);
        COLORS_TO_BLOCKS.put(class_1767.field_7954, class_2246.field_10393);
        COLORS_TO_BLOCKS.put(class_1767.field_7944, class_2246.field_10591);
        COLORS_TO_BLOCKS.put(class_1767.field_7967, class_2246.field_10209);
        COLORS_TO_BLOCKS.put(class_1767.field_7955, class_2246.field_10433);
        COLORS_TO_BLOCKS.put(class_1767.field_7945, class_2246.field_10510);
        COLORS_TO_BLOCKS.put(class_1767.field_7966, class_2246.field_10043);
        COLORS_TO_BLOCKS.put(class_1767.field_7957, class_2246.field_10473);
        COLORS_TO_BLOCKS.put(class_1767.field_7942, class_2246.field_10338);
        COLORS_TO_BLOCKS.put(class_1767.field_7964, class_2246.field_10536);
        COLORS_TO_BLOCKS.put(class_1767.field_7963, class_2246.field_10106);
    }
}

