/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.PostBlock;
import juuxel.adorn.util.Shapes;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public final class PicketFenceBlock
extends class_2248
implements class_3737,
BlockWithDescription {
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final Map<class_2350, class_265> STRAIGHT_OUTLINE_SHAPES = Shapes.buildShapeRotationsFromNorth(0, 0, 7, 16, 16, 9);
    private static final Map<class_2350, class_265> CORNER_OUTLINE_SHAPES = Shapes.mergeIntoShapeMap(Shapes.mergeShapeMaps(Shapes.buildShapeRotationsFromNorth(0, 0, 7, 9, 16, 9), Shapes.buildShapeRotationsFromNorth(7, 0, 9, 9, 16, 16)), PostBlock.Y_SHAPE);
    private static final Map<class_2350, class_265> STRAIGHT_COLLISION_SHAPES = Shapes.buildShapeRotationsFromNorth(0, 0, 7, 16, 24, 9);
    private static final Map<class_2350, class_265> CORNER_COLLISION_SHAPES = Shapes.mergeIntoShapeMap(Shapes.mergeShapeMaps(Shapes.buildShapeRotationsFromNorth(0, 0, 7, 9, 24, 9), Shapes.buildShapeRotationsFromNorth(7, 0, 9, 9, 24, 16)), PicketFenceBlock.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0));

    public PicketFenceBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SHAPE, FACING, WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
        return this.updateShape((class_1922)ctx.method_8045(), ctx.method_8037(), state);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction.method_10166() == ((class_2350)state.method_11654(FACING)).method_10166()) {
            return this.updateShape((class_1922)world, pos, state);
        }
        return state;
    }

    private class_2680 updateShape(class_1922 world, class_2338 pos, class_2680 state) {
        class_2350 fenceFacing = (class_2350)state.method_11654(FACING);
        for (class_2350 side : new class_2350[]{fenceFacing.method_10153(), fenceFacing}) {
            PicketFenceBlock picketFence;
            class_2350 neighborFacing;
            boolean inner = side == fenceFacing;
            class_2680 neighborState = world.method_8320(pos.method_10093(side));
            class_2248 neighborBlock = neighborState.method_26204();
            class_2350 class_23502 = neighborFacing = neighborBlock instanceof PicketFenceBlock ? (class_2350)neighborState.method_11654(FACING) : null;
            Shape shape = neighborFacing == fenceFacing.method_10170() ? (inner ? Shape.CLOCKWISE_INNER_CORNER : Shape.CLOCKWISE_CORNER) : (neighborFacing == fenceFacing.method_10160() ? (inner ? Shape.COUNTERCLOCKWISE_INNER_CORNER : Shape.COUNTERCLOCKWISE_CORNER) : Shape.STRAIGHT);
            if (!(neighborBlock instanceof PicketFenceBlock) || !(picketFence = (PicketFenceBlock)neighborBlock).connectsTo(neighborState, side.method_10153())) {
                shape = Shape.STRAIGHT;
            }
            if (shape == Shape.STRAIGHT) continue;
            return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)shape));
        }
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.STRAIGHT));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (((Shape)((Object)state.method_11654(SHAPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> STRAIGHT_OUTLINE_SHAPES.get(state.method_11654(FACING));
            case 1 -> CORNER_OUTLINE_SHAPES.get(state.method_11654(FACING));
            case 2 -> CORNER_OUTLINE_SHAPES.get(((class_2350)state.method_11654(FACING)).method_10160());
            case 3 -> CORNER_OUTLINE_SHAPES.get(((class_2350)state.method_11654(FACING)).method_10153());
            case 4 -> CORNER_OUTLINE_SHAPES.get(((class_2350)state.method_11654(FACING)).method_10170());
        };
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (((Shape)((Object)state.method_11654(SHAPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> STRAIGHT_COLLISION_SHAPES.get(state.method_11654(FACING));
            case 1 -> CORNER_COLLISION_SHAPES.get(state.method_11654(FACING));
            case 2 -> CORNER_COLLISION_SHAPES.get(((class_2350)state.method_11654(FACING)).method_10160());
            case 3 -> CORNER_COLLISION_SHAPES.get(((class_2350)state.method_11654(FACING)).method_10153());
            case 4 -> CORNER_COLLISION_SHAPES.get(((class_2350)state.method_11654(FACING)).method_10170());
        };
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657(FACING, (Comparable)mirror.method_10343((class_2350)state.method_11654(FACING)));
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public boolean sideCoversSmallSquare(class_2680 state) {
        return state.method_11654(SHAPE) != Shape.STRAIGHT;
    }

    private boolean connectsTo(class_2680 state, class_2350 direction) {
        if (!direction.method_10166().method_10179()) {
            return false;
        }
        class_2350 facing = (class_2350)state.method_11654(FACING);
        return switch (((Shape)((Object)state.method_11654(SHAPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (facing.method_10166() != direction.method_10166()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (direction == facing.method_10160() || direction == facing.method_10153()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (direction == facing.method_10170() || direction == facing.method_10153()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (direction == facing.method_10170() || direction == facing) {
                    yield true;
                }
                yield false;
            }
            case 4 -> direction == facing.method_10160() || direction == facing;
        };
    }

    public static enum Shape implements class_3542
    {
        STRAIGHT("straight"),
        CLOCKWISE_CORNER("clockwise_corner"),
        COUNTERCLOCKWISE_CORNER("counterclockwise_corner"),
        CLOCKWISE_INNER_CORNER("clockwise_inner_corner"),
        COUNTERCLOCKWISE_INNER_CORNER("counterclockwise_inner_corner");

        private final String id;

        private Shape(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }
    }
}

