/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import juuxel.adorn.client.book.Book;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.util.TextBuilder;
import net.minecraft.class_2561;

public final class PageTreeBuilder {
    private final List<Page> pages = new ArrayList<Page>();
    private final IntList pageDepths = new IntArrayList();
    private final IntStack levelStartIndices = new IntArrayList();
    private final int offset;
    private int depth = 0;

    public PageTreeBuilder(int offset) {
        this.offset = offset;
        this.sublevel();
    }

    public PageTreeBuilder sublevel() {
        this.levelStartIndices.push(this.pages.size());
        this.pages.add(null);
        this.pageDepths.add(this.depth);
        ++this.depth;
        return this;
    }

    public PageTreeBuilder page(Page page) {
        this.pages.add(page);
        this.pageDepths.add(this.depth);
        return this;
    }

    public PageTreeBuilder end(Function<class_2561, Page> tocBuilder) {
        --this.depth;
        int tocIndex = this.levelStartIndices.popInt();
        TextBuilder contentBuilder = new TextBuilder();
        contentBuilder.add((class_2561)class_2561.method_43473());
        for (int i = tocIndex + 1; i < this.pages.size(); ++i) {
            int pageDepth;
            String indent;
            if (i != tocIndex + 1) {
                contentBuilder.newLine();
            }
            if (!(indent = "  ".repeat((pageDepth = this.pageDepths.getInt(i)) - this.depth - 1)).isEmpty()) {
                contentBuilder.add((class_2561)class_2561.method_43470((String)indent));
            }
            contentBuilder.add((class_2561)Book.jumpToPage(this.pages.get(i).title().method_27661(), this.offset + i));
        }
        Page toc = tocBuilder.apply((class_2561)contentBuilder.build());
        this.pages.set(tocIndex, toc);
        return this;
    }

    public List<Page> build() {
        if (this.depth > 0) {
            throw new IllegalArgumentException("Cannot build page with unfinished tree level");
        }
        return this.pages;
    }
}

