/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.gui.widget.ConfigScreenHeading;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.util.Displayable;
import juuxel.adorn.util.PropertyRef;
import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.AnimationTask;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import org.joml.Quaternionfc;

public abstract class AbstractConfigScreen
extends class_437 {
    private static final int CONFIG_BUTTON_START_Y = 40;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_GAP = 4;
    public static final int BUTTON_SPACING = 24;
    private static final int HEART_SIZE = 12;
    private static final int[] HEART_COLORS = new int[]{-65536, -227582, -256, -5768104, -13803012, -6290692, -10950148, -220705};
    private static final class_2960 HEART_TEXTURE = AdornCommon.id("textures/gui/heart.png");
    private static final double MIN_HEART_SPEED = 0.05;
    private static final double MAX_HEART_SPEED = 1.5;
    private static final double MAX_HEART_ANGULAR_SPEED = 0.07;
    private static final int HEART_CHANCE = 65;
    private final class_437 parent;
    private final Random random = new Random();
    private final List<Heart> hearts = new ArrayList<Heart>();
    private boolean restartRequired = false;
    private final AnimationEngine animationEngine = new AnimationEngine();
    protected int nextChildY = 40;

    protected AbstractConfigScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
        this.animationEngine.add(new HeartAnimationTask());
    }

    protected void method_25426() {
        this.nextChildY = 40;
        this.animationEngine.start();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25420(class_332 context, int mouseX, int mouseY, float tickProgress) {
        super.method_25420(context, mouseX, mouseY, tickProgress);
        List<Heart> list = this.hearts;
        synchronized (list) {
            this.renderHearts(context, tickProgress);
        }
    }

    private void renderHearts(class_332 context, float delta) {
        for (Heart heart : this.hearts) {
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_22904((double)heart.x, class_3532.method_16436((double)delta, (double)heart.previousY, (double)heart.y), 0.0);
            matrices.method_22904(6.0, 6.0, 0.0);
            double angle = class_3532.method_16436((double)delta, (double)heart.previousAngle, (double)heart.angle);
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation((float)angle));
            matrices.method_22904(-6.0, -6.0, 0.0);
            context.method_25293(class_1921::method_62277, HEART_TEXTURE, 0, 0, 0.0f, 0.0f, 12, 12, 8, 8, 8, 8, heart.color);
            matrices.method_22909();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)(this.restartRequired ? new class_403(() -> this.field_22787.method_1507(this.parent), (class_2561)class_2561.method_43471((String)"gui.adorn.config.restart_required.title"), (class_2561)class_2561.method_43471((String)"gui.adorn.config.restart_required.message"), (class_2561)class_2561.method_43471((String)"gui.ok"), true) : this.parent));
    }

    public void method_25432() {
        this.animationEngine.stop();
    }

    private void tickHearts() {
        Iterator<Heart> iter = this.hearts.iterator();
        while (iter.hasNext()) {
            Heart heart = iter.next();
            if (heart.y - 12.0 > (double)this.field_22790) {
                iter.remove();
                continue;
            }
            heart.move();
        }
        if (this.random.nextInt(65) == 0) {
            int x = this.random.nextInt(this.field_22789);
            int color = HEART_COLORS[this.random.nextInt(HEART_COLORS.length)];
            double speed = this.random.nextDouble(0.05, 1.5);
            double angularSpeed = this.random.nextDouble(-0.07, 0.07);
            this.hearts.add(new Heart(x, -12.0, color, speed, angularSpeed));
        }
    }

    private <T> class_5676<T> createConfigButton(class_5676.class_5677<T> builder, int x, int y, int width, PropertyRef<T> property, boolean restartRequired) {
        return builder.method_32618(value -> {
            class_5250 text = class_2561.method_43471((String)this.getTooltipTranslationKey(property.getName()));
            if (restartRequired) {
                text.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"gui.adorn.config.requires_restart").method_27695(new class_124[]{class_124.field_1056, class_124.field_1065}));
            }
            return class_7919.method_47407((class_2561)text);
        }).method_32617(x, y, width, 20, (class_2561)class_2561.method_43471((String)this.getOptionTranslationKey(property.getName())), (button, value) -> {
            property.set(value);
            ConfigManager.get().save();
            if (restartRequired) {
                this.restartRequired = true;
            }
        });
    }

    protected void addConfigToggle(int width, PropertyRef<Boolean> property) {
        this.addConfigToggle(width, property, false);
    }

    protected void addConfigToggle(int width, PropertyRef<Boolean> property, boolean restartRequired) {
        class_5676<Boolean> button = this.createConfigButton(class_5676.method_32613((boolean)property.get()), (this.field_22789 - width) / 2, this.nextChildY, width, property, restartRequired);
        this.method_37063((class_364)button);
        this.nextChildY += 24;
    }

    protected <T extends Displayable> void addConfigButton(int width, PropertyRef<T> property, List<T> values) {
        this.addConfigButton(width, property, values, false);
    }

    protected <T extends Displayable> void addConfigButton(int width, PropertyRef<T> property, List<T> values, boolean restartRequired) {
        class_5676<T> button = this.createConfigButton(class_5676.method_32606(Displayable::getDisplayName).method_32620(values).method_32619((Object)((Displayable)property.get())), (this.field_22789 - width) / 2, this.nextChildY, width, property, restartRequired);
        this.method_37063((class_364)button);
        this.nextChildY += 24;
    }

    protected void addHeading(class_2561 text, int width) {
        this.method_37060(new ConfigScreenHeading(text, (this.field_22789 - width) / 2, this.nextChildY, width));
        this.nextChildY += 18;
    }

    protected String getOptionTranslationKey(String name) {
        return "gui.adorn.config.option." + name;
    }

    private String getTooltipTranslationKey(String name) {
        return this.getOptionTranslationKey(name) + ".description";
    }

    private final class HeartAnimationTask
    implements AnimationTask {
        private HeartAnimationTask() {
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tick() {
            List<Heart> list = AbstractConfigScreen.this.hearts;
            synchronized (list) {
                AbstractConfigScreen.this.tickHearts();
            }
        }
    }

    private static final class Heart {
        private final int x;
        private double y;
        private final int color;
        private final double speed;
        private final double angularSpeed;
        private double previousY;
        private double previousAngle = 0.0;
        private double angle = 0.0;

        private Heart(int x, double y, int color, double speed, double angularSpeed) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.speed = speed;
            this.angularSpeed = angularSpeed;
            this.previousY = y;
        }

        private void move() {
            this.previousY = this.y;
            this.y += this.speed;
            this.previousAngle = this.angle;
            this.angle = (this.angle + this.angularSpeed) % 6.2831854820251465;
        }
    }
}

