/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.menu.AdornMenus;
import juuxel.adorn.networking.BrewerFluidSyncS2CMessage;
import juuxel.adorn.platform.PlatformBridges;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.jetbrains.annotations.Nullable;

public final class BrewerMenu
extends class_1703 {
    private final class_1263 container;
    private final class_3913 propertyDelegate;
    private FluidReference fluid;
    private final class_1657 player;
    @Nullable
    private FluidVolume lastFluid = null;

    public BrewerMenu(int syncId, class_1661 playerInventory, class_1263 container, class_3913 propertyDelegate, FluidReference fluid) {
        super((class_3917)AdornMenus.BREWER.get(), syncId);
        this.container = container;
        this.propertyDelegate = propertyDelegate;
        this.fluid = fluid;
        this.player = playerInventory.field_7546;
        BrewerMenu.method_17359((class_1263)container, (int)4);
        BrewerMenu.method_17361((class_3913)propertyDelegate, (int)1);
        this.method_7621(new MainSlot(container, 0, 80, 56));
        this.method_7621(new class_1735(container, 1, 50, 17));
        this.method_7621(new class_1735(container, 2, 110, 17));
        this.method_7621(new FluidContainerSlot(container, 3, 123, 60));
        for (int y = 0; y <= 2; ++y) {
            for (int x = 0; x <= 8; ++x) {
                this.method_7621(new class_1735((class_1263)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x <= 8; ++x) {
            this.method_7621(new class_1735((class_1263)playerInventory, x, 8 + x * 18, 142));
        }
        this.method_17360(propertyDelegate);
    }

    public BrewerMenu(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, (class_1263)new class_1277(4), (class_3913)new class_3919(1), FluidVolume.empty(FluidUnit.LITRE));
    }

    public int getProgress() {
        return this.propertyDelegate.method_17390(0);
    }

    public FluidReference getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidReference fluid) {
        this.fluid = fluid;
    }

    public boolean method_7597(class_1657 player) {
        return this.container.method_5443(player);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if (index <= 3) {
                if (!this.method_7616(stack, 4, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else {
                class_1735 mugSlot = (class_1735)this.field_7761.get(0);
                if (!mugSlot.method_7681() && mugSlot.method_7680(stack)) {
                    mugSlot.method_53512(stack.method_7971(Math.min(mugSlot.method_7676(stack), stack.method_7947())));
                }
                if (!stack.method_7960() && !this.method_7616(stack, 1, 4, false)) {
                    return class_1799.field_8037;
                }
            }
            if (stack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return result;
    }

    public void method_7623() {
        super.method_7623();
        FluidVolume last = this.lastFluid;
        if (last == null || !FluidReference.areFluidsAndAmountsEqual(this.fluid, last)) {
            this.lastFluid = this.fluid.createSnapshot();
            PlatformBridges.get().getNetwork().sendToClient(this.player, new BrewerFluidSyncS2CMessage(this.field_7763, this.fluid.createSnapshot()));
        }
    }

    private static final class MainSlot
    extends class_1735 {
        private MainSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int method_7675() {
            return 1;
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_31574((class_1792)AdornItems.MUG.get());
        }
    }

    private static final class FluidContainerSlot
    extends class_1735 {
        private FluidContainerSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int method_7675() {
            return 1;
        }
    }
}

