/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.mojang.serialization.MapCodec;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.VisibleBlockWithEntity;
import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.criterion.BoughtFromTradingStationCriterion;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.trading.Trade;
import net.minecraft.class_10;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public final class TradingStationBlock
extends VisibleBlockWithEntity
implements BlockWithDescription {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 OUTLINE_SHAPE = class_259.method_1084((class_265)TradingStationBlock.method_9541((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265)TradingStationBlock.createLegShape());
    private static final class_265 COLLISION_SHAPE = class_259.method_1084((class_265)TradingStationBlock.method_9541((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265)TradingStationBlock.createLegShape());

    public TradingStationBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof TradingStationBlockEntity) {
                TradingStationBlockEntity tradingStation = (TradingStationBlockEntity)class_25862;
                tradingStation.setOwnerIfMissing(player);
            }
        }
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_52422;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TradingStationBlockEntity) {
            TradingStationBlockEntity be = (TradingStationBlockEntity)class_25862;
            be.setOwnerIfMissing(player);
            if (!be.isOwner(player)) {
                Trade trade = be.getTrade();
                boolean validPayment = class_1799.method_31577((class_1799)stack, (class_1799)trade.getPrice()) && stack.method_7947() >= trade.getPrice().method_7947();
                boolean canInsertPayment = be.getStorage().canInsert(trade.getPrice());
                if (trade.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.adorn.trading_station.empty_trade"), true);
                } else if (!be.isStorageStocked()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.adorn.trading_station.storage_not_stocked"), true);
                } else if (!canInsertPayment) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.adorn.trading_station.storage_full"), true);
                } else if (validPayment) {
                    stack.method_7934(trade.getPrice().method_7947());
                    class_1799 soldItem = trade.getSelling().method_7972();
                    player.method_7270(soldItem);
                    be.getStorage().tryExtract(trade.getSelling());
                    be.getStorage().tryInsert(trade.getPrice());
                    player.method_7281(AdornStats.INTERACT_WITH_TRADING_STATION);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        ((BoughtFromTradingStationCriterion)((Object)AdornCriteria.BOUGHT_FROM_TRADING_STATION.get())).trigger(serverPlayer, soldItem);
                    }
                }
            } else {
                player.method_17355((class_3908)be);
                player.method_7281(AdornStats.INTERACT_WITH_TRADING_STATION);
            }
        }
        return class_1269.field_52422;
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        class_1264.method_66221((class_2680)state, (class_1937)world, (class_2338)pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPE;
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ((class_2591)AdornBlockEntities.TRADING_STATION.get()).method_11032(pos, state);
    }

    protected MapCodec<? extends class_2237> method_53969() {
        throw new UnsupportedOperationException();
    }

    private static class_265 createLegShape() {
        return class_259.method_17786((class_265)TradingStationBlock.method_9541((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), (class_265[])new class_265[]{TradingStationBlock.method_9541((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), TradingStationBlock.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), TradingStationBlock.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0)});
    }
}

