/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.client.book.PageTreeBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public record Book(class_2561 title, class_2561 subtitle, class_2561 author, List<Page> pages, float titleScale) {
    public static final Codec<Book> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.fieldOf("title").forGetter(Book::title), (App)class_8824.field_46597.fieldOf("subtitle").forGetter(Book::subtitle), (App)class_8824.field_46597.fieldOf("author").forGetter(Book::author), (App)Page.CODEC.listOf().fieldOf("pages").forGetter(Book::pages), (App)Codec.FLOAT.fieldOf("titleScale").forGetter(Book::titleScale)).apply((Applicative)instance, Book::new));

    public static Builder builder() {
        return new Builder();
    }

    public static class_5250 jumpToPage(class_5250 text, int page) {
        return text.method_27692(class_124.field_1073).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10605(page)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43469((String)"guide.adorn.contents.jump_to_page", (Object[])new Object[]{page}).method_27692(class_124.field_1056))));
    }

    public static final class Builder {
        @Nullable
        private class_2561 title;
        @Nullable
        private class_2561 subtitle;
        @Nullable
        private class_2561 author;
        private final List<Page> pages = new ArrayList<Page>();
        private float titleScale = 1.0f;

        private Builder() {
        }

        public Builder title(class_2561 title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(class_2561 subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder author(class_2561 author) {
            this.author = author;
            return this;
        }

        public Builder page(Page page) {
            this.pages.add(page);
            return this;
        }

        public Builder pageTree(UnaryOperator<PageTreeBuilder> builderOp) {
            this.pages.addAll(((PageTreeBuilder)builderOp.apply(new PageTreeBuilder(this.pages.size() + 2))).build());
            return this;
        }

        public Builder titleScale(float titleScale) {
            this.titleScale = titleScale;
            return this;
        }

        public Book build() {
            Objects.requireNonNull(this.title);
            Objects.requireNonNull(this.subtitle);
            Objects.requireNonNull(this.author);
            return new Book(this.title, this.subtitle, this.author, List.copyOf(this.pages), this.titleScale);
        }
    }
}

