/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.trading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import juuxel.adorn.trading.TradeInventory;
import juuxel.adorn.util.NbtConvertible;
import juuxel.adorn.util.NbtUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class Trade
implements NbtConvertible,
class_5632 {
    public static final Codec<Trade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_49266.fieldOf("selling").forGetter(Trade::getSelling), (App)class_1799.field_49266.fieldOf("price").forGetter(Trade::getPrice)).apply((Applicative)instance, Trade::new));
    public static final String NBT_SELLING = "Selling";
    public static final String NBT_PRICE = "Price";
    private class_1799 selling;
    private class_1799 price;
    private final List<TradeListener> listeners = new ArrayList<TradeListener>();

    public Trade(class_1799 selling, class_1799 price) {
        this.selling = selling;
        this.price = price;
    }

    public class_1799 getSelling() {
        return this.selling;
    }

    public void setSelling(class_1799 selling) {
        this.selling = selling;
    }

    public class_1799 getPrice() {
        return this.price;
    }

    public void setPrice(class_1799 price) {
        this.price = price;
    }

    public boolean isEmpty() {
        return this.selling.method_7960() || this.price.method_7960();
    }

    public boolean isFullyEmpty() {
        return this.selling.method_7960() && this.price.method_7960();
    }

    @Override
    public void readNbt(class_2487 nbt, class_7225.class_7874 registries) {
        this.selling = NbtUtil.getWithCodec(nbt, NBT_SELLING, class_1799.field_49266, registries, class_1799.field_8037);
        this.price = NbtUtil.getWithCodec(nbt, NBT_PRICE, class_1799.field_49266, registries, class_1799.field_8037);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 registries) {
        NbtUtil.putWithCodec(nbt, NBT_SELLING, class_1799.field_49266, this.selling, registries);
        NbtUtil.putWithCodec(nbt, NBT_PRICE, class_1799.field_49266, this.price, registries);
        return nbt;
    }

    public void copyFrom(@Nullable Trade trade) {
        if (trade == null) {
            return;
        }
        this.selling = trade.selling.method_7972();
        this.price = trade.price.method_7972();
    }

    public void addListener(TradeListener listener) {
        this.listeners.add(listener);
    }

    public void callListeners() {
        for (TradeListener listener : this.listeners) {
            listener.onTradeChanged(this);
        }
    }

    public TradeInventory createInventory() {
        return new TradeInventory(this);
    }

    public int hashCode() {
        return Objects.hash(this.selling, this.price);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Trade)) {
            return false;
        }
        Trade other = (Trade)obj;
        return this.selling.equals(other.selling) && this.price.equals(other.price);
    }

    public static Trade empty() {
        return new Trade(class_1799.field_8037, class_1799.field_8037);
    }

    public static Trade fromNbt(class_2487 nbt, class_7225.class_7874 registries) {
        Trade trade = Trade.empty();
        trade.readNbt(nbt, registries);
        return trade;
    }

    @FunctionalInterface
    public static interface TradeListener {
        public void onTradeChanged(Trade var1);
    }
}

