/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tlauncher.injection.Injection;
import org.tlauncher.injection.InjectionHelper;

public class InjectionManager {
    private static final List<Injection> EMPTY_INJECTION_LIST = new ArrayList<Injection>();
    private final Map<String, List<Injection>> injectionMap = new HashMap<String, List<Injection>>();
    private final Map<String, InjectionHelper> injectionHelperMap = new HashMap<String, InjectionHelper>();
    private final Map<String, Boolean> isInjectionIgnoredMap;

    public InjectionManager(Map<String, Boolean> isInjectionIgnoredMap) {
        this.isInjectionIgnoredMap = isInjectionIgnoredMap;
    }

    public void addInjection(String injectionId, String targetClassName, Injection injection) {
        if (this.isInjectionIgnoredMap.containsKey(injectionId)) {
            System.out.printf("[Injection] Injection %s is completely ignored\n", injectionId);
            return;
        }
        this.injectionMap.putIfAbsent(targetClassName, new ArrayList());
        this.injectionMap.get(targetClassName).add(injection);
        this.injectionHelperMap.putIfAbsent(targetClassName, new InjectionHelper());
    }

    public InjectionHelper getHelper(String targetClassName) {
        return this.injectionHelperMap.get(targetClassName);
    }

    public List<Injection> getInjections(String targetClassName) {
        return this.injectionMap.getOrDefault(targetClassName, EMPTY_INJECTION_LIST);
    }
}

