/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.cache.Cache;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1438;
import net.minecraft.class_1472;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_5147;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8551;
import net.minecraft.class_8710;
import net.minecraft.class_9280;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.TraceableException;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.compat.TechRebornEnergyCompat;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;
import snownee.jade.mixin.AbstractHorseAccess;
import snownee.jade.network.ClientHandshakePacket;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerHandshakePacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.util.JadeFabricUtils;
import snownee.jade.util.UsernameCache;
import snownee.jade.util.WailaExceptionHandler;
import team.reborn.energy.api.EnergyStorage;

public final class CommonProxy
implements ModInitializer {
    public static boolean hasTechRebornEnergy = CommonProxy.isModLoaded("team_reborn_energy");

    @Nullable
    public static String getLastKnownUsername(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Optional optional = class_2631.method_59539((UUID)uuid).getNow(Optional.empty());
        if (optional.isPresent()) {
            return ((GameProfile)optional.get()).getName();
        }
        if (CommonProxy.isPhysicallyClient()) {
            return UsernameCache.getLastKnownUsername(uuid);
        }
        return null;
    }

    public static File getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    public static boolean isCorrectToolForDrops(class_2680 state, class_1657 player, class_1937 level, class_2338 pos) {
        return player.method_7305(state);
    }

    public static String getModIdFromItem(class_1799 stack) {
        class_6880 holder;
        class_1844 potionContents;
        String namespace;
        class_2960 id;
        String modid;
        class_9280 modelData;
        if (CommonProxy.isPhysicallyClient() && !class_9280.field_55212.equals((Object)(modelData = (class_9280)stack.method_58695(class_9334.field_49637, (Object)class_9280.field_55212)))) {
            for (String string : modelData.comp_3356()) {
                if (!string.startsWith("namespace:")) continue;
                return string.substring(10);
            }
        }
        if (stack.method_57826(class_9334.field_49643)) {
            class_9304 enchantments = (class_9304)stack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385);
            modid = null;
            for (class_6880 enchantmentHolder : enchantments.method_57534()) {
                id = enchantmentHolder.method_40230().map(class_5321::method_29177).orElse(null);
                if (id == null) continue;
                namespace = id.method_12836();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if ((potionContents = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)).method_57405()) {
            modid = null;
            for (class_1293 effect : potionContents.method_57397()) {
                id = effect.method_5579().method_40230().map(class_5321::method_29177).orElse(null);
                if (id == null) continue;
                namespace = id.method_12836();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if (stack.method_31574(class_1802.field_8892) && (holder = (class_6880)stack.method_58694(class_9334.field_56138)) != null) {
            return holder.method_40230().map(class_5321::method_29177).map(class_2960::method_12836).orElse("minecraft");
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
    }

    public static boolean isPhysicallyClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static ItemCollector<?> createItemCollector(Accessor<?> accessor, Cache<Object, ItemCollector<?>> containerCache) {
        if (accessor.getTarget() instanceof AbstractHorseAccess) {
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(o -> {
                if (o instanceof AbstractHorseAccess) {
                    AbstractHorseAccess horse = (AbstractHorseAccess)((Object)o);
                    return horse.getInventory();
                }
                return null;
            }, 2));
        }
        try {
            Storage<ItemVariant> storage = CommonProxy.findItemHandler(accessor);
            if (storage != null) {
                return (ItemCollector)containerCache.get(storage, () -> new ItemCollector<Storage<ItemVariant>>(JadeFabricUtils.fromItemStorage(storage, 0)));
            }
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(e, null, null);
        }
        class_1263 container = CommonProxy.findContainer(accessor);
        if (container != null) {
            if (container instanceof class_2595) {
                return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(a -> {
                    Object patt0$temp = a.getTarget();
                    if (patt0$temp instanceof class_2595) {
                        class_2281 chestBlock;
                        class_1263 compound;
                        class_2595 be = (class_2595)patt0$temp;
                        class_2248 patt1$temp = be.method_11010().method_26204();
                        if (patt1$temp instanceof class_2281 && (compound = class_2281.method_17458((class_2281)(chestBlock = (class_2281)patt1$temp), (class_2680)be.method_11010(), (class_1937)Objects.requireNonNull(be.method_10997()), (class_2338)be.method_11016(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<class_1799>> containerGroup(class_1263 container, Accessor<?> accessor) {
        return CommonProxy.containerGroup(container, accessor, CommonProxy::findContainer);
    }

    @Nullable
    public static List<ViewGroup<class_1799>> containerGroup(class_1263 container, Accessor<?> accessor, Function<Accessor<?>, class_1263> containerFinder) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get((Object)container, () -> new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(containerFinder, 0)))).update(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<class_1799>> storageGroup(Object storage, Accessor<?> accessor) {
        return CommonProxy.storageGroup(storage, accessor, CommonProxy::findItemHandler);
    }

    @Nullable
    public static List<ViewGroup<class_1799>> storageGroup(Object storage, Accessor<?> accessor, Function<Accessor<?>, Object> storageFinder) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get(storage, () -> new ItemCollector<Storage<ItemVariant>>(JadeFabricUtils.fromItemStorage((Storage<ItemVariant>)((Storage)storage), 0, storageFinder)))).update(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Storage<ItemVariant> findItemHandler(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return (Storage)ItemStorage.SIDED.find(blockAccessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
        }
        return null;
    }

    @Nullable
    public static class_1263 findContainer(Accessor<?> accessor) {
        BlockAccessor blockAccessor;
        class_2248 class_22482;
        Object target = accessor.getTarget();
        if (target == null && accessor instanceof BlockAccessor && (class_22482 = (blockAccessor = (BlockAccessor)accessor).getBlock()) instanceof class_3954) {
            class_3954 holder = (class_3954)class_22482;
            return holder.method_17680(blockAccessor.getBlockState(), (class_1936)accessor.getLevel(), blockAccessor.getPosition());
        }
        if (target instanceof class_1263) {
            class_1263 container = (class_1263)target;
            return container;
        }
        return null;
    }

    public static List<ViewGroup<FluidView.Data>> wrapFluidStorage(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            try {
                Storage storage = (Storage)FluidStorage.SIDED.find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
                if (storage != null) {
                    return JadeFabricUtils.fromFluidStorage((Storage<FluidVariant>)storage);
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        return null;
    }

    public static List<ViewGroup<EnergyView.Data>> wrapEnergyStorage(Accessor<?> accessor) {
        if (hasTechRebornEnergy && accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            try {
                EnergyStorage storage = (EnergyStorage)TechRebornEnergyCompat.getSided().find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
                if (storage != null && storage.getCapacity() > 0L) {
                    ViewGroup<EnergyView.Data> group = new ViewGroup<EnergyView.Data>(List.of(new EnergyView.Data(storage.getAmount(), storage.getCapacity())));
                    group.getExtraData().method_10582("Unit", "E");
                    return List.of(group);
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        return null;
    }

    public static boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static class_2960 getId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static class_2960 getId(class_1299<?> entityType) {
        return class_7923.field_41177.method_10221(entityType);
    }

    public static class_2960 getId(class_2591<?> blockEntityType) {
        return class_7923.field_41181.method_10221(blockEntityType);
    }

    public static String getPlatformIdentifier() {
        return "fabric";
    }

    public static class_5250 getProfessionName(class_3852 profession) {
        return class_2561.method_43471((String)(class_1299.field_6077.method_5882() + "." + class_7923.field_41195.method_10221((Object)profession).method_12832()));
    }

    private static void registerServerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        JadeServerCommand.register(dispatcher);
    }

    public static boolean isBoss(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        return entityType.method_20210(ConventionalEntityTypeTags.BOSSES) || entityType == class_1299.field_6116 || entityType == class_1299.field_6119;
    }

    public static class_1799 getBlockPickedResult(class_2680 state, class_1657 player, class_3965 hitResult) {
        return state.method_65171((class_4538)player.method_37908(), hitResult.method_17777(), true);
    }

    public static class_1799 getEntityPickedResult(class_1297 entity, class_1657 player, class_3966 hitResult) {
        class_1799 stack = entity.method_31480();
        return stack == null ? class_1799.field_8037 : stack;
    }

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static Optional<String> getModVersion(String modid) {
        return FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Version::getFriendlyString);
    }

    public static void loadComplete() {
        Jade.loadPlugins();
    }

    public static List<Entrypoint> loadEntrypoints() {
        return FabricLoader.getInstance().getEntrypointContainers("jade", IWailaPlugin.class).stream().map(Entrypoint::new).toList();
    }

    public static class_2561 getFluidName(JadeFluidObject fluidObject) {
        class_3611 fluid = fluidObject.getType();
        class_9326 components = fluidObject.getComponents();
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid, (class_9326)components));
    }

    public static boolean isMultipartEntity(class_1297 target) {
        return target instanceof class_1510;
    }

    public static class_1297 wrapPartEntityParent(class_1297 target) {
        if (target instanceof class_1508) {
            class_1508 part = (class_1508)target;
            return part.field_7007;
        }
        return target;
    }

    public static int getPartEntityIndex(class_1297 entity) {
        if (!(entity instanceof class_1508)) {
            return -1;
        }
        class_1508 part = (class_1508)entity;
        class_1297 class_12972 = CommonProxy.wrapPartEntityParent(entity);
        if (!(class_12972 instanceof class_1510)) {
            return -1;
        }
        class_1510 parent = (class_1510)class_12972;
        class_1508[] parts = parent.method_5690();
        return List.of(parts).indexOf(part);
    }

    public static class_1297 getPartEntity(class_1297 parent, int index) {
        class_1510 dragon;
        class_1508[] parts;
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        if (parent instanceof class_1510 && index < (parts = (dragon = (class_1510)parent).method_5690()).length) {
            return parts[index];
        }
        return parent;
    }

    public static boolean hasDefaultItemStorage(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            if (blockAccessor.getBlockEntity() == null) {
                return blockAccessor.getBlock() instanceof class_3954;
            }
            return ItemStorage.SIDED.find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null) != null;
        }
        return true;
    }

    public static boolean hasDefaultFluidStorage(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return FluidStorage.SIDED.find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null) != null;
        }
        return true;
    }

    public static boolean hasDefaultEnergyStorage(Accessor<?> accessor) {
        if (hasTechRebornEnergy && accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return TechRebornEnergyCompat.getSided().find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null) != null;
        }
        return true;
    }

    public static long bucketVolume() {
        return 81000L;
    }

    public static long blockVolume() {
        return 81000L;
    }

    public static void registerTagsUpdatedListener(BiConsumer<class_7225.class_7874, Boolean> listener) {
        CommonLifecycleEvents.TAGS_LOADED.register(listener::accept);
    }

    public static boolean isCorrectConditions(List<class_5341> conditions, class_1799 toolItem) {
        if (conditions.size() != 1) {
            return false;
        }
        class_5341 condition = conditions.getFirst();
        if (condition instanceof class_223) {
            class_223 matchTool = (class_223)condition;
            class_2073 itemPredicate = matchTool.comp_1884().orElse(null);
            return itemPredicate != null && itemPredicate.method_8970(toolItem);
        }
        if (condition instanceof class_8551) {
            class_8551 anyOfCondition = (class_8551)condition;
            for (class_5341 child : anyOfCondition.field_1246) {
                if (!CommonProxy.isCorrectConditions(List.of(child), toolItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Map.Entry<class_2960, List<ViewGroup<T>>> getServerExtensionData(Accessor<?> accessor, WrappedHierarchyLookup<IServerExtensionProvider<T>> lookup) {
        for (IServerExtensionProvider<T> provider : lookup.wrappedGet(accessor)) {
            List<ViewGroup<T>> groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null);
                continue;
            }
            if (groups == null) continue;
            return Map.entry(provider.getUid(), groups);
        }
        return null;
    }

    public static String defaultEnergyUnit() {
        return "E";
    }

    public static void sendPacket(class_3222 player, class_8710 payload) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static boolean isSheared(class_1297 entity) {
        class_5147 shearable;
        if (entity instanceof class_5147 && !(shearable = (class_5147)entity).method_27072()) {
            if (entity instanceof class_1472 || entity instanceof class_1438) {
                return !((class_1429)entity).method_6109();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static Either<String, class_2561> getTranslatableName(Object object) {
        return null;
    }

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(ReceiveDataPacket.TYPE, ReceiveDataPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestBlockPacket.TYPE, RequestBlockPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestEntityPacket.TYPE, RequestEntityPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ClientHandshakePacket.TYPE, ClientHandshakePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ServerHandshakePacket.TYPE, ServerHandshakePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ShowOverlayPacket.TYPE, ShowOverlayPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestEntityPacket.TYPE, (payload, context) -> RequestEntityPacket.handle(payload, () -> ((ServerPlayNetworking.Context)context).player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestBlockPacket.TYPE, (payload, context) -> RequestBlockPacket.handle(payload, () -> ((ServerPlayNetworking.Context)context).player()));
        ServerPlayNetworking.registerGlobalReceiver(ClientHandshakePacket.TYPE, (payload, context) -> ClientHandshakePacket.handle(payload, () -> ((ServerPlayNetworking.Context)context).player()));
        CommandRegistrationCallback.EVENT.register(CommonProxy::registerServerCommand);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (server.method_3816()) {
                CommonProxy.loadComplete();
            }
        });
    }

    public record Entrypoint(EntrypointContainer<IWailaPlugin> container) {
        public String className() {
            return this.container.getDefinition();
        }

        public String modId() {
            return this.container.getProvider().getMetadata().getId();
        }

        public String modName() {
            return this.container.getProvider().getMetadata().getName();
        }

        public String requiredMod() {
            try {
                Class<?> clazz = Class.forName(this.className());
                WailaPlugin a = clazz.getDeclaredAnnotation(WailaPlugin.class);
                return a == null ? "" : a.value();
            }
            catch (ClassNotFoundException e) {
                return "";
            }
        }

        public IWailaPlugin newInstance() {
            try {
                return (IWailaPlugin)this.container.getEntrypoint();
            }
            catch (Throwable e) {
                this.throwError("Failed to instantiate plugin class");
                throw new AssertionError();
            }
        }

        public void throwError(String message, @Nullable Throwable cause) {
            message = "Error in plugin class %s from %s: %s".formatted(this.className(), this.modName(), message);
            cause = cause == null ? new IllegalStateException(message) : new IllegalStateException(message, cause);
            throw new TraceableException(cause, this.modId());
        }

        public void throwError(String message) {
            this.throwError(message, null);
        }
    }
}

