/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.config.option;

import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.ConfigOptionType;
import com.unlikepaladin.pfm.config.option.ConfigSizeTracker;
import com.unlikepaladin.pfm.config.option.Side;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class BooleanConfigOption
extends AbstractConfigOption<Boolean> {
    public static final ConfigOptionType<BooleanConfigOption> TYPE = new ConfigOptionType<BooleanConfigOption>(){

        @Override
        public BooleanConfigOption read(DataInput dataInput, int i, ConfigSizeTracker nbtTagSizeTracker) throws IOException {
            nbtTagSizeTracker.add(2400L);
            String title = dataInput.readUTF();
            String tooltip = dataInput.readUTF();
            String category = dataInput.readUTF();
            boolean value = dataInput.readBoolean();
            Side side = AbstractConfigOption.getSide(dataInput.readUTF());
            nbtTagSizeTracker.add(224L + 16L * (long)title.length());
            nbtTagSizeTracker.add(224L + 16L * (long)tooltip.length());
            nbtTagSizeTracker.add(224L + 16L * (long)category.length());
            nbtTagSizeTracker.add(64L);
            BooleanConfigOption booleanConfigOption = new BooleanConfigOption((class_2561)class_2561.method_43471((String)title), (class_2561)class_2561.method_43471((String)tooltip), category, value, side);
            return booleanConfigOption;
        }

        @Override
        public String getCrashReportName() {
            return "END";
        }

        @Override
        public boolean isImmutable() {
            return true;
        }
    };
    private final class_2561 title;
    private final class_2561 tooltip;
    private final String category;
    private boolean value;
    private final boolean defaultValue;
    private final Side side;

    public BooleanConfigOption(class_2561 title, class_2561 tooltip, String category, boolean value, Side side) {
        this.title = title;
        this.category = category;
        this.tooltip = tooltip;
        this.value = value;
        this.defaultValue = value;
        this.side = side;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public class_2561 getToolTip() {
        return this.tooltip;
    }

    @Override
    public void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public boolean isDefault() {
        return this.value == this.defaultValue;
    }

    @Override
    public Side getSide() {
        return this.side;
    }

    @Override
    public byte getConfigType() {
        return 1;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeUTF(((class_2588)this.title.method_10851()).method_11022());
        output.writeUTF(((class_2588)this.tooltip.method_10851()).method_11022());
        output.writeUTF(this.category);
        output.writeBoolean(this.value);
        output.writeUTF(this.side.method_15434());
    }
}

