/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.class_10124;
import net.minecraft.class_10128;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.ConsumableFood;
import squeek.appleskin.helpers.ExhaustionHelper;
import squeek.appleskin.network.ClientSyncHandler;

public class FoodHelper {
    public static class_4174 EMPTY_FOOD_COMPONENT = new class_4174.class_4175().method_19242();
    public static class_10124 DEFAULT_CONSUMABLE_COMPONENT = class_10128.field_53779;
    public static float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static float MAX_EXHAUSTION = 4.0f;

    public static boolean isFood(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_50075) && itemStack.method_57826(class_9334.field_53964);
    }

    public static boolean canConsume(class_1657 player, class_4174 foodComponent) {
        return player.method_7332(foodComponent.comp_2493());
    }

    public static ConsumableFood getDefaultFoodValues(class_1799 itemStack) {
        return new ConsumableFood((class_4174)itemStack.method_58695(class_9334.field_50075, (Object)EMPTY_FOOD_COMPONENT), (class_10124)itemStack.method_58695(class_9334.field_53964, (Object)DEFAULT_CONSUMABLE_COMPONENT));
    }

    @Nullable
    public static QueriedFoodResult query(class_1799 itemStack, class_1657 player) {
        if (!FoodHelper.isFood(itemStack)) {
            return null;
        }
        ConsumableFood defaultFood = FoodHelper.getDefaultFoodValues(itemStack);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent(player, itemStack, defaultFood.food(), defaultFood.food());
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact(foodValuesEvent);
        return new QueriedFoodResult(foodValuesEvent.defaultFoodComponent, foodValuesEvent.modifiedFoodComponent, defaultFood.consumable(), itemStack);
    }

    public static boolean isRotten(class_10124 consumableComponent) {
        for (class_10134 effect : consumableComponent.comp_3089()) {
            if (!(effect instanceof class_10132)) continue;
            for (class_1293 statusEffect : ((class_10132)effect).comp_3094()) {
                if (((class_1291)statusEffect.method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
                return true;
            }
        }
        return false;
    }

    public static float getEstimatedHealthIncrement(class_1657 player, ConsumableFood consumableFood) {
        if (!player.method_7317()) {
            return 0.0f;
        }
        class_1702 stats = player.method_7344();
        class_1937 world = player.method_5770();
        int foodLevel = Math.min(stats.method_7586() + consumableFood.food().comp_2491(), 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 18.0f && ClientSyncHandler.naturalRegeneration) {
            float saturationLevel = Math.min(stats.method_7589() + consumableFood.food().comp_2492(), (float)foodLevel);
            float exhaustionLevel = ExhaustionHelper.getExhaustion(player);
            healthIncrement = FoodHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        block0: for (class_10134 effect : consumableFood.consumable().comp_3089()) {
            if (!(effect instanceof class_10132)) continue;
            for (class_1293 statusEffect : ((class_10132)effect).comp_3094()) {
                if (statusEffect.method_5579() != class_1294.field_5924) continue;
                int amplifier = statusEffect.method_5578();
                int duration = statusEffect.method_5584();
                healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
                continue block0;
            }
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > MAX_EXHAUSTION) {
                exhaustionLevel -= MAX_EXHAUSTION;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, REGEN_EXHAUSTION_INCREMENT);
                float exhaustionUntilAboveMax = Math.nextUp(MAX_EXHAUSTION) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / REGEN_EXHAUSTION_INCREMENT * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += REGEN_EXHAUSTION_INCREMENT;
        }
        return health;
    }

    public static class QueriedFoodResult {
        public class_4174 defaultFoodComponent;
        public class_4174 modifiedFoodComponent;
        public class_10124 consumableComponent;
        public final class_1799 itemStack;

        public QueriedFoodResult(class_4174 defaultFoodComponent, class_4174 modifiedFoodComponent, class_10124 consumableComponent, class_1799 itemStack) {
            this.defaultFoodComponent = defaultFoodComponent;
            this.modifiedFoodComponent = modifiedFoodComponent;
            this.consumableComponent = consumableComponent;
            this.itemStack = itemStack;
        }
    }
}

