/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.immediate;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.InputStream;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.class_1011;
import net.minecraft.class_10789;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5912;
import net.minecraft.class_638;
import net.minecraft.class_758;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9958;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-CloudRenderer");
    private static final RenderPipeline.Snippet CLOUD_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).withUniform("ColorModulator", class_10789.field_56746).withUniform("FogStart", class_10789.field_56743).withUniform("FogEnd", class_10789.field_56743).withUniform("FogShape", class_10789.field_56741).withUniform("FogColor", class_10789.field_56746).withUniform("ModelViewMat", class_10789.field_56747).withUniform("ProjMat", class_10789.field_56747).withDepthTestFunction(DepthTestFunction.LESS_DEPTH_TEST).withVertexShader(class_2960.method_60655((String)"sodium", (String)"clouds")).withFragmentShader(class_2960.method_60655((String)"sodium", (String)"clouds")).buildSnippet();
    public static final RenderPipeline CLOUDS_FULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{CLOUD_SNIPPET}).withCull(true).withLocation(class_2960.method_60655((String)"sodium", (String)"clouds_full")).build();
    public static final RenderPipeline CLOUDS_FLAT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{CLOUD_SNIPPET}).withCull(false).withLocation(class_2960.method_60655((String)"sodium", (String)"clouds_flat")).build();
    private static final class_2960 CLOUDS_TEXTURE_ID = class_2960.method_60656((String)"textures/environment/clouds.png");
    private static final float CLOUD_HEIGHT = 4.0f;
    private static final float CLOUD_WIDTH = 12.0f;
    private static final int FACE_MASK_NEG_Y = 1;
    private static final int FACE_MASK_POS_Y = 2;
    private static final int FACE_MASK_NEG_X = 4;
    private static final int FACE_MASK_POS_X = 8;
    private static final int FACE_MASK_NEG_Z = 16;
    private static final int FACE_MASK_POS_Z = 32;
    private static final int BRIGHTNESS_POS_Y = ColorU8.normalizedFloatToByte(1.0f);
    private static final int BRIGHTNESS_NEG_Y = ColorU8.normalizedFloatToByte(0.7f);
    private static final int BRIGHTNESS_X_AXIS = ColorU8.normalizedFloatToByte(0.9f);
    private static final int BRIGHTNESS_Z_AXIS = ColorU8.normalizedFloatToByte(0.8f);
    @Nullable
    private CloudTextureData textureData;
    @Nullable
    private CloudGeometry builtGeometry;

    public CloudRenderer(class_5912 resourceProvider) {
        this.reload(resourceProvider);
    }

    public void render(class_4184 camera, class_638 level, Matrix4f projectionMatrix, Matrix4f modelView, float ticks, float tickDelta, int color) {
        GpuBuffer vertexBuffer;
        float height = level.method_28103().method_28108() + 0.33f;
        if (Float.isNaN(height)) {
            return;
        }
        if (this.textureData == null) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        int renderDistance = CloudRenderer.getCloudRenderDistance();
        class_4063 renderMode = class_310.method_1551().field_1690.method_1632();
        double worldX = cameraPos.field_1352 + (double)(ticks + tickDelta) * 0.03;
        double worldZ = cameraPos.field_1350 + 3.96;
        double textureWidth = (float)this.textureData.width * 12.0f;
        double textureHeight = (float)this.textureData.height * 12.0f;
        worldX -= (double)class_3532.method_15357((double)(worldX / textureWidth)) * textureWidth;
        worldZ -= (double)class_3532.method_15357((double)(worldZ / textureHeight)) * textureHeight;
        int cellX = class_3532.method_15357((double)(worldX / 12.0));
        int cellZ = class_3532.method_15357((double)(worldZ / 12.0));
        ViewOrientation orientation = renderMode == class_4063.field_18164 ? ViewOrientation.getOrientation(cameraPos, height, height + 4.0f) : null;
        CloudGeometryParameters parameters = new CloudGeometryParameters(cellX, cellZ, renderDistance, orientation, renderMode);
        CloudGeometry geometry = this.builtGeometry;
        if (geometry == null || !Objects.equals(geometry.params(), parameters)) {
            this.builtGeometry = geometry = CloudRenderer.rebuildGeometry(geometry, parameters, this.textureData);
        }
        if ((vertexBuffer = geometry.vertexBuffer()) == null) {
            return;
        }
        float viewPosX = (float)(worldX - (double)((float)cellX * 12.0f));
        float viewPosY = (float)cameraPos.method_10214() - height;
        float viewPosZ = (float)(worldZ - (double)((float)cellZ * 12.0f));
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)modelView);
        modelViewMatrix.translate(-viewPosX, -viewPosY, -viewPosZ);
        class_9958 prevFogParameters = CloudRenderer.copyShaderFogParameters(RenderSystem.getShaderFog());
        boolean flat = geometry.params().renderMode() == class_4063.field_18163;
        class_9958 fogParameters = class_758.method_3211((class_4184)camera, (class_758.class_4596)class_758.class_4596.field_20946, (Vector4f)new Vector4f(prevFogParameters.comp_3012(), prevFogParameters.comp_3013(), prevFogParameters.comp_3014(), prevFogParameters.comp_3015()), (float)(renderDistance * 8), (boolean)CloudRenderer.shouldUseWorldFog(level, cameraPos), (float)tickDelta);
        RenderSystem.setShaderColor((float)class_9848.method_65101((int)color), (float)class_9848.method_65102((int)color), (float)class_9848.method_65103((int)color), (float)0.8f);
        RenderSystem.setShaderFog((class_9958)fogParameters);
        class_276 renderTarget = class_310.method_1551().field_1769.method_29364() == null ? class_310.method_1551().method_1522() : class_310.method_1551().field_1769.method_29364();
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)modelViewMatrix);
        RenderSystem.class_5590 index = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer indices = index.method_68274(this.builtGeometry.indexCount);
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.method_30278(), OptionalDouble.empty());){
            renderPass.setPipeline(flat ? CLOUDS_FLAT : CLOUDS_FULL);
            renderPass.setIndexBuffer(indices, index.method_31924());
            renderPass.setVertexBuffer(0, vertexBuffer);
            renderPass.drawIndexed(0, this.builtGeometry.indexCount);
        }
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.setShaderFog((class_9958)prevFogParameters);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @NotNull
    private static CloudGeometry rebuildGeometry(@Nullable CloudGeometry existingGeometry, CloudGeometryParameters parameters, CloudTextureData textureData) {
        int layer;
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        VertexBufferWriter writer = VertexBufferWriter.of((class_4588)bufferBuilder);
        int radius = parameters.radius();
        ViewOrientation orientation = parameters.orientation();
        boolean flat = parameters.renderMode() == class_4063.field_18163;
        CloudTextureData.Slice slice = textureData.slice(parameters.originX(), parameters.originZ(), radius);
        CloudRenderer.addCellGeometryToBuffer(writer, slice, 0, 0, orientation, flat);
        for (layer = 1; layer <= radius; ++layer) {
            int x;
            int z;
            for (z = -layer; z < layer; ++z) {
                x = Math.abs(z) - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = layer; z > -layer; --z) {
                x = layer - Math.abs(z);
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
        }
        for (layer = radius + 1; layer <= 2 * radius; ++layer) {
            int x;
            int z;
            int l = layer - radius;
            for (z = -radius; z <= -l; ++z) {
                x = -z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = l; z <= radius; ++z) {
                x = z - layer;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = radius; z >= l; --z) {
                x = layer - z;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
            for (z = -l; z >= -radius; --z) {
                x = layer + z;
                CloudRenderer.addCellGeometryToBuffer(writer, slice, x, z, orientation, flat);
            }
        }
        @Nullable class_9801 meshData = bufferBuilder.method_60794();
        GpuBuffer vertexBuffer = null;
        if (existingGeometry != null) {
            vertexBuffer = existingGeometry.vertexBuffer();
        }
        if (meshData != null) {
            if (vertexBuffer == null || vertexBuffer.size() < meshData.method_60818().remaining()) {
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Cloud vertex buffer", BufferType.VERTICES, BufferUsage.DYNAMIC_WRITE, meshData.method_60818());
            } else {
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer, meshData.method_60818(), 0);
            }
            meshData.close();
        } else if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
        class_289.method_1348().method_60828();
        return new CloudGeometry(vertexBuffer, meshData.method_60822().comp_751(), parameters);
    }

    private static void addCellGeometryToBuffer(VertexBufferWriter writer, CloudTextureData.Slice textureData, int x, int z, @Nullable ViewOrientation orientation, boolean flat) {
        int index = textureData.getCellIndex(x, z);
        int faces = textureData.getCellFaces(index) & CloudRenderer.getVisibleFaces(x, z, orientation);
        if (faces == 0) {
            return;
        }
        int color = textureData.getCellColor(index);
        if (CloudRenderer.isTransparent(color)) {
            return;
        }
        if (flat) {
            CloudRenderer.emitCellGeometryFlat(writer, color, x, z);
        } else {
            CloudRenderer.emitCellGeometryExterior(writer, faces, color, x, z);
            if (CloudRenderer.taxicabDistance(x, z) <= 1) {
                CloudRenderer.emitCellGeometryInterior(writer, color, x, z);
            }
        }
    }

    private static int getVisibleFaces(int x, int z, ViewOrientation orientation) {
        int faces = 0;
        if (x <= 0) {
            faces |= 8;
        }
        if (z <= 0) {
            faces |= 0x20;
        }
        if (x >= 0) {
            faces |= 4;
        }
        if (z >= 0) {
            faces |= 0x10;
        }
        if (orientation != ViewOrientation.BELOW_CLOUDS) {
            faces |= 2;
        }
        if (orientation != ViewOrientation.ABOVE_CLOUDS) {
            faces |= 1;
        }
        return faces;
    }

    private static void emitCellGeometryFlat(VertexBufferWriter writer, int texel, int x, int z) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long vertexBuffer;
            long ptr = vertexBuffer = stack.nmalloc(64);
            float x0 = (float)x * 12.0f;
            float x1 = x0 + 12.0f;
            float z0 = (float)z * 12.0f;
            float z1 = z0 + 12.0f;
            int color = ColorABGR.mulRGB(texel, BRIGHTNESS_POS_Y);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, color);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, color);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, color);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, color);
            writer.push(stack, vertexBuffer, 4, ColorVertex.FORMAT);
        }
    }

    private static void emitCellGeometryExterior(VertexBufferWriter writer, int cellFaces, int cellColor, int cellX, int cellZ) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            int vertexColor;
            long vertexBuffer = stack.nmalloc(384);
            int vertexCount = 0;
            long ptr = vertexBuffer;
            float x0 = (float)cellX * 12.0f;
            float y0 = 0.0f;
            float z0 = (float)cellZ * 12.0f;
            float x1 = x0 + 12.0f;
            float y1 = 4.0f;
            float z1 = z0 + 12.0f;
            if ((cellFaces & 1) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_NEG_Y);
                ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
                vertexCount += 4;
            }
            if ((cellFaces & 2) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_POS_Y);
                ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
                ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
                vertexCount += 4;
            }
            if ((cellFaces & 0xC) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_X_AXIS);
                if ((cellFaces & 4) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
                    vertexCount += 4;
                }
                if ((cellFaces & 8) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
                    vertexCount += 4;
                }
            }
            if ((cellFaces & 0x30) != 0) {
                vertexColor = ColorABGR.mulRGB(cellColor, BRIGHTNESS_Z_AXIS);
                if ((cellFaces & 0x10) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
                    vertexCount += 4;
                }
                if ((cellFaces & 0x20) != 0) {
                    ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
                    ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
                    vertexCount += 4;
                }
            }
            writer.push(stack, vertexBuffer, vertexCount, ColorVertex.FORMAT);
        }
    }

    private static void emitCellGeometryInterior(VertexBufferWriter writer, int baseColor, int cellX, int cellZ) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long vertexBuffer;
            long ptr = vertexBuffer = stack.nmalloc(384);
            float x0 = (float)cellX * 12.0f;
            float y0 = 0.0f;
            float z0 = (float)cellZ * 12.0f;
            float x1 = x0 + 12.0f;
            float y1 = 4.0f;
            float z1 = z0 + 12.0f;
            int vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_NEG_Y);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
            vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_POS_Y);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
            vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_X_AXIS);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
            vertexColor = ColorABGR.mulRGB(baseColor, BRIGHTNESS_Z_AXIS);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z0, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 0.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x0, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 4.0f, z1, vertexColor);
            ptr = CloudRenderer.writeVertex(ptr, x1, 0.0f, z1, vertexColor);
            writer.push(stack, vertexBuffer, 24, ColorVertex.FORMAT);
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    public void reload(class_5912 resourceProvider) {
        this.destroy();
        this.textureData = CloudRenderer.loadTextureData(resourceProvider);
    }

    public void destroy() {
        if (this.builtGeometry != null) {
            GpuBuffer vertexBuffer = this.builtGeometry.vertexBuffer();
            if (vertexBuffer != null) {
                vertexBuffer.close();
            }
            this.builtGeometry = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static CloudTextureData loadTextureData(class_5912 resourceProvider) {
        class_3298 resource = (class_3298)resourceProvider.method_14486(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.method_14482();){
            CloudTextureData cloudTextureData;
            block14: {
                class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                try {
                    cloudTextureData = CloudTextureData.load(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudTextureData;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load texture '{}'. The rendering of clouds in the skybox will be disabled. This may be caused by an incompatible resource pack.", (Object)CLOUDS_TEXTURE_ID, (Object)t);
            return null;
        }
    }

    private static boolean shouldUseWorldFog(class_638 level, class_243 pos) {
        return level.method_28103().method_28110(class_3532.method_15357((double)pos.method_10216()), class_3532.method_15357((double)pos.method_10215())) || class_310.method_1551().field_1705.method_1740().method_1800();
    }

    private static int getCloudRenderDistance() {
        return Math.max(32, class_310.method_1551().field_1690.method_38521() * 2 + 9);
    }

    private static boolean isTransparent(int argb) {
        return ColorARGB.unpackAlpha(argb) < 10;
    }

    private static int taxicabDistance(int x, int z) {
        return Math.abs(x) + Math.abs(z);
    }

    private static class_9958 copyShaderFogParameters(class_9958 shaderFog) {
        return new class_9958(shaderFog.comp_3009(), shaderFog.comp_3010(), shaderFog.comp_3011(), shaderFog.comp_3012(), shaderFog.comp_3013(), shaderFog.comp_3014(), shaderFog.comp_3015());
    }

    private static class CloudTextureData {
        private final byte[] faces;
        private final int[] colors;
        private final int width;
        private final int height;

        private CloudTextureData(int width, int height) {
            this.faces = new byte[width * height];
            this.colors = new int[width * height];
            this.width = width;
            this.height = height;
        }

        public Slice slice(int originX, int originY, int radius) {
            CloudTextureData src = this;
            Slice dst = new Slice(radius);
            for (int dstY = 0; dstY < dst.height; ++dstY) {
                int length;
                int srcX = Math.floorMod(originX - radius, this.width);
                int srcY = Math.floorMod(originY - radius + dstY, this.height);
                for (int dstX = 0; dstX < dst.width; dstX += length) {
                    length = Math.min(src.width - srcX, dst.width - dstX);
                    int srcPos = CloudTextureData.getCellIndex(srcX, srcY, src.width);
                    int dstPos = CloudTextureData.getCellIndex(dstX, dstY, dst.width);
                    System.arraycopy(this.faces, srcPos, dst.faces, dstPos, length);
                    System.arraycopy(this.colors, srcPos, dst.colors, dstPos, length);
                    srcX = 0;
                }
            }
            return dst;
        }

        @Nullable
        public static CloudTextureData load(class_1011 image) {
            int height;
            int width = image.method_4307();
            CloudTextureData data = new CloudTextureData(width, height = image.method_4323());
            if (!data.loadTextureData(image, width, height)) {
                return null;
            }
            return data;
        }

        private boolean loadTextureData(class_1011 texture, int width, int height) {
            Validate.isTrue((this.width == width ? 1 : 0) != 0);
            Validate.isTrue((this.height == height ? 1 : 0) != 0);
            boolean containsData = false;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int color = texture.method_61940(x, z);
                    if (CloudRenderer.isTransparent(color)) continue;
                    int index = CloudTextureData.getCellIndex(x, z, width);
                    this.colors[index] = color;
                    this.faces[index] = (byte)CloudTextureData.getOpenFaces(texture, color, x, z);
                    containsData = true;
                }
            }
            return containsData;
        }

        private static int getOpenFaces(class_1011 image, int color, int x, int z) {
            int faces = 3;
            int neighbor = CloudTextureData.getNeighborTexel(image, x - 1, z);
            if (color != neighbor) {
                faces |= 4;
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x + 1, z))) {
                faces |= 8;
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z - 1))) {
                faces |= 0x10;
            }
            if (color != (neighbor = CloudTextureData.getNeighborTexel(image, x, z + 1))) {
                faces |= 0x20;
            }
            return faces;
        }

        private static int getNeighborTexel(class_1011 image, int x, int z) {
            x = CloudTextureData.wrapTexelCoord(x, 0, image.method_4307() - 1);
            z = CloudTextureData.wrapTexelCoord(z, 0, image.method_4323() - 1);
            return image.method_61940(x, z);
        }

        private static int wrapTexelCoord(int coord, int min, int max) {
            if (coord < min) {
                coord = max;
            }
            if (coord > max) {
                coord = min;
            }
            return coord;
        }

        private static int getCellIndex(int x, int z, int pitch) {
            return z * pitch + x;
        }

        public static class Slice {
            private final int width;
            private final int height;
            private final int radius;
            private final byte[] faces;
            private final int[] colors;

            public Slice(int radius) {
                this.width = 1 + radius * 2;
                this.height = 1 + radius * 2;
                this.radius = radius;
                this.faces = new byte[this.width * this.height];
                this.colors = new int[this.width * this.height];
            }

            public int getCellIndex(int x, int z) {
                return CloudTextureData.getCellIndex(x + this.radius, z + this.radius, this.width);
            }

            public int getCellFaces(int index) {
                return Byte.toUnsignedInt(this.faces[index]);
            }

            public int getCellColor(int index) {
                return this.colors[index];
            }
        }
    }

    private static enum ViewOrientation {
        BELOW_CLOUDS,
        INSIDE_CLOUDS,
        ABOVE_CLOUDS;


        @NotNull
        public static ViewOrientation getOrientation(class_243 camera, float minY, float maxY) {
            if (camera.method_10214() <= (double)(minY + 0.125f)) {
                return BELOW_CLOUDS;
            }
            if (camera.method_10214() >= (double)(maxY - 0.125f)) {
                return ABOVE_CLOUDS;
            }
            return INSIDE_CLOUDS;
        }
    }

    public record CloudGeometryParameters(int originX, int originZ, int radius, @Nullable ViewOrientation orientation, class_4063 renderMode) {
    }

    public record CloudGeometry(@Nullable GpuBuffer vertexBuffer, int indexCount, CloudGeometryParameters params) {
    }
}

