/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.blockentities.SinkBlockEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import net.minecraft.class_10;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5620;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSinkBlock
extends class_2275
implements class_2343 {
    public static final class_2758 LEVEL_4 = class_2758.method_11867((String)"level", (int)0, (int)3);
    final class_5620.class_8821 behaviorMap;
    final class_1959.class_1963 precipitation;
    public static MapCodec<AbstractSinkBlock> CODEC = null;

    public AbstractSinkBlock(class_4970.class_2251 settings, class_1959.class_1963 precipitation, class_5620.class_8821 behaviorMap) {
        super(settings.method_9631(state -> 0).method_26249((blockstate, b, c) -> false), behaviorMap);
        this.behaviorMap = behaviorMap;
        this.precipitation = precipitation;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf(0)));
        if (CODEC == null) {
            CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1959.class_1963.field_46251.fieldOf("precipitation").forGetter(block -> block.precipitation), (App)class_5620.field_46590.fieldOf("interactions").forGetter(block -> block.behaviorMap), (App)AbstractSinkBlock.method_54096()).apply((Applicative)instance, (precipitation1, cauldronBehaviorMap, settings1) -> (AbstractSinkBlock)((Object)((Object)((Object)this.getSinkConstructor().apply(settings1, precipitation1, cauldronBehaviorMap))))));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481});
        stateManager.method_11667(new class_2769[]{LEVEL_4});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042());
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_5620 sinkBehavior = (class_5620)this.behaviorMap.comp_1982().get(itemStack.method_7909());
        if (sinkBehavior != null && itemStack.method_7909() != class_1802.field_8162) {
            return sinkBehavior.interact(state, world, pos, player, hand, itemStack);
        }
        return class_1269.field_52423;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2338 sourcePos;
        class_2680 sourceState;
        if ((Integer)state.method_11654((class_2769)LEVEL_4) < 3 && (sourceState = world.method_8320(sourcePos = pos.method_10074().method_10074())).method_26227().method_15772() == class_3612.field_15910 && !sourceState.method_26227().method_15769()) {
            if (sourceState.method_28501().contains(class_2741.field_12508)) {
                world.method_8501(sourcePos, (class_2680)sourceState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
            } else {
                world.method_8501(sourcePos, class_2246.field_10124.method_9564());
            }
            SinkBlockEntity blockEntity = (SinkBlockEntity)world.method_8321(pos);
            if (blockEntity != null) {
                blockEntity.setFilling(true);
            }
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf(3)));
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LEVEL_4);
    }

    protected void method_32764(class_2680 state, class_1937 world, class_2338 pos, class_3611 fluid) {
        if (this.method_32766(state)) {
            return;
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL_4) + 1)));
        world.method_20290(1047, pos, 0);
    }

    protected static boolean canFillWithPrecipitation(class_1937 world, class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382) {
            return world.method_8409().method_43057() < 0.05f;
        }
        if (precipitation == class_1959.class_1963.field_9383) {
            return world.method_8409().method_43057() < 0.1f;
        }
        return false;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.SINK_BLOCK_ENTITY, SinkBlockEntity::tick);
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        if (!AbstractSinkBlock.canFillWithPrecipitation(world, precipitation) || (Integer)state.method_11654((class_2769)LEVEL_4) == 3 || precipitation != this.precipitation) {
            return;
        }
        world.method_8501(pos, (class_2680)state.method_28493((class_2769)LEVEL_4));
    }

    public static void spawnParticles(class_2350 facing, class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            if (facing == class_2350.field_11034) {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11035) {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11043) {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
            } else {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return SinkBlockEntity.getFactory().create(pos, state);
    }

    protected double method_31615(class_2680 state) {
        return (6.0 + (double)((Integer)state.method_11654((class_2769)LEVEL_4)).intValue() * 3.0) / 16.0;
    }

    protected boolean method_32765(class_3611 fluid) {
        return fluid == class_3612.field_15910 && this.precipitation == class_1959.class_1963.field_9382;
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL_4) == 3;
    }

    public static void decrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        int i = (Integer)state.method_11654((class_2769)LEVEL_4) - 1;
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_4, (Comparable)Integer.valueOf(i)));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected void onFireCollision(class_2680 state, class_1937 world, class_2338 pos) {
        if ((Integer)state.method_11654((class_2769)LEVEL_4) > 0) {
            AbstractSinkBlock.decrementFluidLevel(state, world, pos);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (entity.method_5809() && this.method_31616(state, pos, entity)) {
                entity.method_5646();
                if (entity.method_36971(serverWorld, pos)) {
                    this.onFireCollision(state, world, pos);
                }
            }
        }
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)class_2383.field_11177, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2383.field_11177)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)class_2383.field_11177)));
    }

    protected MapCodec<? extends class_2275> method_53969() {
        return CODEC;
    }

    public abstract Function3<class_4970.class_2251, class_1959.class_1963, class_5620.class_8821, AbstractSinkBlock> getSinkConstructor();
}

