/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMFeatureFlagFactory;
import com.unlikepaladin.pfm.registry.BlockItemRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7696;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StoneVariant
extends VariantBase<StoneVariant> {
    private final class_2248 polishedBlock;
    private final class_2248 rawBlock;

    StoneVariant(class_2960 identifier, class_2248 polishedBlock, class_2248 rawBlock) {
        super(identifier);
        this.polishedBlock = polishedBlock;
        this.rawBlock = rawBlock;
    }

    public String method_15434() {
        String postfix = this.isVanilla() ? "" : "_" + this.getNamespace();
        return this.identifier.method_12832() + postfix;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2960 getTexture(BlockType type) {
        if (type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.rawBlock);
        }
        return ModelHelper.getTextureId(this.polishedBlock);
    }

    @Override
    public String getPath() {
        return this.identifier.method_12832();
    }

    @Override
    public class_2248 getBaseBlock() {
        return this.polishedBlock;
    }

    @Override
    public class_2248 getSecondaryBlock() {
        return this.rawBlock;
    }

    public class_2248 getRawBlock() {
        return this.rawBlock;
    }

    public String toString() {
        return this.identifier.toString();
    }

    @Override
    public boolean isNetherWood() {
        return this.identifier.method_12832().contains("warped") || this.identifier.method_12832().contains("crimson");
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.method_12836().equals("") || this.identifier.method_12836().equals("minecraft");
    }

    @Override
    public List<class_7696> getFeatureList() {
        class_7696 flag = PFMFeatureFlagFactory.newFlag(this.getBaseBlock().method_45322().field_40174, 0);
        flag.field_40164 = this.getBaseBlock().method_45322().field_40175;
        return List.of(flag);
    }

    @Override
    public StoneVariant getVariantType() {
        return this;
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("slab", this.findRelatedEntry("slab", class_7923.field_41175));
        this.addChild("stairs", this.findRelatedEntry("stairs", class_7923.field_41175));
        this.addChild("wall", this.findRelatedEntry("fence", class_7923.field_41175));
    }

    @Override
    @Nullable
    public class_1935 getItemForRecipe(String key, Class<? extends class_2248> blockClass) {
        class_1935 itemConvertible = super.getItemForRecipe(key, blockClass);
        if ((this.identifier.method_12832().equals("calcite") || this.identifier.method_12832().equals("netherite")) && (key.equals("base") || key.equals("secondary")) && blockClass.getSimpleName().contains("Kitchen")) {
            if (itemConvertible == this.getBaseBlock()) {
                return this.getSecondaryBlock();
            }
            return this.getBaseBlock();
        }
        return itemConvertible;
    }

    @Override
    public void initializeChildrenItems() {
    }

    public boolean hasStripped() {
        Object child = this.getChild("stripped_log");
        return child != null && child != this.getBaseBlock();
    }

    @Override
    public class_2248 mainChild() {
        return this.polishedBlock;
    }

    public static class Finder
    implements VariantBase.SetFinder<StoneVariant> {
        private final Map<String, class_2960> childNames = new HashMap<String, class_2960>();
        private final Supplier<class_2248> polishedFinder;
        private final Supplier<class_2248> rawFinder;
        private final class_2960 id;

        public Finder(class_2960 id, Supplier<class_2248> polished, Supplier<class_2248> raw) {
            this.id = id;
            this.polishedFinder = polished;
            this.rawFinder = raw;
        }

        public static Finder simple(String modId, String stoneTypeName, String polishedName, String rawName) {
            return Finder.simple(class_2960.method_60655((String)modId, (String)stoneTypeName), class_2960.method_60655((String)modId, (String)polishedName), class_2960.method_60655((String)modId, (String)rawName));
        }

        public static Finder simple(class_2960 stoneTypeName, class_2960 polishedName, class_2960 rawName) {
            return new Finder(stoneTypeName, () -> (class_2248)class_7923.field_41175.method_63535(polishedName), () -> (class_2248)class_7923.field_41175.method_63535(rawName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, class_2960.method_60655((String)this.id.method_12836(), (String)childName));
        }

        public void addChild(String childType, class_2960 childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        public Optional<StoneVariant> get() {
            if (BlockItemRegistry.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 plank = this.polishedFinder.get();
                    class_2248 log = this.rawFinder.get();
                    class_2248 d = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60655((String)"minecraft", (String)"air"));
                    if (plank != d && log != d && plank != null && log != null) {
                        StoneVariant w = new StoneVariant(this.id, plank, log);
                        for (Map.Entry<String, class_2960> entry : this.childNames.entrySet()) {
                            Object child = class_7923.field_41175.method_17966(entry.getValue()).isPresent() ? class_7923.field_41175.method_63535(entry.getValue()) : class_7923.field_41178.method_63535(entry.getValue());
                            w.addChild(entry.getKey(), child);
                        }
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Failed to find custom stone type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

