/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2231;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WoodVariantRegistry
extends VariantRegistryBase<WoodVariant> {
    public static final WoodVariant OAK = new WoodVariant(class_2960.method_60654((String)"oak"), class_2246.field_10161, class_2246.field_10431);
    public static final WoodVariantRegistry INSTANCE = new WoodVariantRegistry();

    public static Collection<String> getNamespaces() {
        return WoodVariantRegistry.INSTANCE.variants.values().stream().map(VariantBase::getNamespace).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<WoodVariant> getVariants() {
        return Collections.unmodifiableCollection(WoodVariantRegistry.INSTANCE.variants.values());
    }

    @Nullable
    public static WoodVariant getVariant(class_2960 name) {
        return WoodVariantRegistry.INSTANCE.variants.getOrDefault(name, OAK);
    }

    public static Optional<WoodVariant> getOptionalVariant(class_2960 name) {
        return WoodVariantRegistry.INSTANCE.variants.containsKey(name) ? Optional.of((WoodVariant)WoodVariantRegistry.INSTANCE.variants.get(name)) : Optional.empty();
    }

    @Override
    public Optional<WoodVariant> getVariantFromBlock(class_2248 baseBlock, class_2960 blockId) {
        class_2680 state;
        String name = null;
        String path = blockId.method_12832();
        if (blockId.method_12836().equals("tfc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = class_7923.field_41175.method_17966(class_2960.method_60655((String)blockId.method_12836(), (String)path.replace("planks", "log")))).isPresent()) {
                class_2960 id = class_2960.method_60655((String)blockId.method_12836(), (String)path.replace("wood/planks/", ""));
                return Optional.of(new WoodVariant(id, baseBlock, (class_2248)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = blockId.method_12836();
        if (!(namespace.equals("cozy_home") || name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || namespace.equals("terrestria") && path.contains("sakura") || namespace.equals("betternether") && path.contains("nether_mushroom") || namespace.equals("chipped") || namespace.equals("regions_unexplored") && path.contains("alpha") || namespace.equals("modernlife") || namespace.equals("excessive_building") || (state = baseBlock.method_9564()).method_28501().size() > 2 || baseBlock instanceof class_2482 || name.contains("slab") || baseBlock instanceof class_2231 || name.contains("pressure_plate"))) {
            class_2498 soundGroup = state.method_26231();
            class_2766 instrument = state.method_51364();
            if (soundGroup == class_2498.field_40314 || soundGroup == class_2498.field_42766 || soundGroup == class_2498.field_11547 || soundGroup == class_2498.field_40315 || instrument == class_2766.field_12651) {
                name = name.replace("/", "_");
                class_2960 id = class_2960.method_60655((String)blockId.method_12836(), (String)name);
                class_2248 logBlock = WoodVariantRegistry.findLog(id);
                if (logBlock != null) {
                    return Optional.of(new WoodVariant(id, baseBlock, logBlock));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public WoodVariant getDefaultType() {
        return OAK;
    }

    @Override
    public Class<WoodVariant> getType() {
        return WoodVariant.class;
    }

    @Nullable
    private static class_2248 findLog(class_2960 id) {
        class_2960[] test = new class_2960[]{class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_log")), class_2960.method_60655((String)id.method_12836(), (String)("log_" + id.method_12832())), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "log")), class_2960.method_60654((String)(id.method_12832() + "_log")), class_2960.method_60654((String)("log_" + id.method_12832())), class_2960.method_60654((String)(id.method_12832() + "log")), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_stem")), class_2960.method_60655((String)id.method_12836(), (String)("stem_" + id.method_12832())), class_2960.method_60654((String)(id.method_12832() + "_stem")), class_2960.method_60654((String)("stem_" + id.method_12832())), class_2960.method_60655((String)id.method_12836(), (String)("stalk_" + id.method_12832())), class_2960.method_60654((String)(id.method_12832() + "_stalk")), class_2960.method_60654((String)("stalk_" + id.method_12832()))};
        class_2248 temp = null;
        for (class_2960 r : test) {
            if (!class_7923.field_41175.method_10250(r)) continue;
            temp = (class_2248)class_7923.field_41175.method_63535(r);
            break;
        }
        return temp;
    }
}

