/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_9129;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;

public interface FurnitureRecipe
extends class_1860<FurnitureRecipeInput> {
    default public class_3956<? extends class_1860<FurnitureRecipeInput>> method_17716() {
        return RecipeTypes.FURNITURE_RECIPE;
    }

    public List<CraftableFurnitureRecipe> getInnerRecipes(class_7699 var1);

    public String outputClass();

    default public List<CraftableFurnitureRecipe> getAvailableOutputs(FurnitureRecipeInput inventory, class_7225.class_7874 registryManager) {
        return this.getInnerRecipes(inventory.playerInventory.field_7546.method_37908().method_45162());
    }

    public static int getSlotWithStackIgnoreNBT(class_1661 inventory, class_1792 item) {
        for (int i = 0; i < inventory.method_67533().size(); ++i) {
            if (((class_1799)inventory.method_67533().get(i)).method_7960() || ((class_1799)inventory.method_67533().get(i)).method_7909() != item) continue;
            return i;
        }
        return -1;
    }

    default public int getMaxInnerRecipeSize() {
        return this.method_61671().method_64675().size();
    }

    default public int getOutputCount(class_7225.class_7874 registryManager) {
        return this.getResult(registryManager).method_7947();
    }

    public class_1799 getResult(class_7225.class_7874 var1);

    default public List<? extends CraftableFurnitureRecipe> getInnerRecipesForVariant(class_1937 world, class_2960 identifier) {
        return Collections.singletonList(this.getInnerRecipes(world.method_45162()).getFirst());
    }

    default public String getName(class_7225.class_7874 registryManager) {
        return this.getResult(registryManager).method_7964().getString();
    }

    public void write(class_9129 var1);

    default public boolean enabled(class_1937 world) {
        for (CraftableFurnitureRecipe recipe : this.getInnerRecipes(world.method_45162())) {
            if (recipe.isInnerEnabled(world.method_45162())) continue;
            return false;
        }
        return true;
    }

    default public List<class_1856> getIngredients(class_1937 world) {
        return this.method_61671().method_64675();
    }

    public record FurnitureRecipeInput(class_1661 playerInventory) implements class_9695
    {
        public class_1799 method_59984(int slot) {
            return this.playerInventory.method_5438(slot);
        }

        public int method_59983() {
            return this.playerInventory.method_5439();
        }

        public boolean method_59987() {
            return this.playerInventory.method_5442();
        }
    }

    public static interface CraftableFurnitureRecipe
    extends Comparable<CraftableFurnitureRecipe> {
        public List<class_1856> getIngredients();

        public class_1799 getResult(class_7225.class_7874 var1);

        public class_1799 craft(FurnitureRecipeInput var1, class_7225.class_7874 var2);

        public boolean matches(FurnitureRecipeInput var1, class_1937 var2);

        public FurnitureRecipe parent();

        public class_1799 getRecipeOuput();

        @Override
        default public int compareTo(@NotNull CraftableFurnitureRecipe o) {
            return this.getRecipeOuput().toString().compareTo(o.getRecipeOuput().toString());
        }

        default public boolean isInnerEnabled(class_7699 featureSet) {
            if (!this.getRecipeOuput().method_45435(featureSet)) {
                return false;
            }
            for (class_1856 ingredient : this.getIngredients()) {
                for (class_6880 item : ingredient.method_8105().toList()) {
                    if (((class_1792)item.comp_349()).method_45382(featureSet)) continue;
                    return false;
                }
            }
            return true;
        }

        default public class_1799 craftAndRemoveItems(FurnitureRecipeInput input, class_7225.class_7874 registryManager) {
            class_1799 output = this.getResult(registryManager).method_7972();
            List<class_1856> ingredients = this.getIngredients();
            class_1661 playerInventory = input.playerInventory();
            Map<class_1792, Integer> ingredientCounts = this.getItemCounts();
            for (Map.Entry<class_1792, Integer> entry : ingredientCounts.entrySet()) {
                class_1792 item = entry.getKey();
                Integer count = entry.getValue();
                int indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, item);
                if (indexOfStack == -1) continue;
                if (playerInventory.method_5438(indexOfStack).method_7947() >= count) {
                    class_1799 stack1 = playerInventory.method_5438(indexOfStack);
                    stack1.method_7934(count.intValue());
                    playerInventory.method_5447(indexOfStack, stack1);
                    playerInventory.method_5431();
                    continue;
                }
                int remainingCount = count - playerInventory.method_5438(indexOfStack).method_7947();
                playerInventory.method_5447(indexOfStack, class_1799.field_8037);
                while (remainingCount > 0) {
                    indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, item);
                    if (indexOfStack != -1) {
                        class_1799 stack1 = playerInventory.method_5438(indexOfStack);
                        if (stack1.method_7947() >= remainingCount) {
                            stack1.method_7934(remainingCount);
                            playerInventory.method_5447(indexOfStack, stack1);
                            break;
                        }
                        int stackSize = stack1.method_7947();
                        remainingCount = Math.max(remainingCount - stackSize, 0);
                        playerInventory.method_5447(indexOfStack, class_1799.field_8037);
                        continue;
                    }
                    PaladinFurnitureMod.GENERAL_LOGGER.warn("Unable to craft recipe, this should never happen");
                    return class_1799.field_8037;
                }
                playerInventory.method_5431();
            }
            return output;
        }

        default public Map<class_1792, Integer> getItemCounts() {
            HashMap<class_1792, Integer> ingredientCounts = new HashMap<class_1792, Integer>();
            for (class_1856 ingredient : this.getIngredients()) {
                for (class_6880 itemRegistryEntry : ingredient.method_8105().toList()) {
                    if (ingredientCounts.containsKey(itemRegistryEntry.comp_349())) {
                        ingredientCounts.put((class_1792)itemRegistryEntry.comp_349(), (Integer)ingredientCounts.get(itemRegistryEntry.comp_349()) + 1);
                        continue;
                    }
                    ingredientCounts.put((class_1792)itemRegistryEntry.comp_349(), 1);
                }
            }
            return ingredientCounts;
        }
    }
}

