/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.group.GroupEntry;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_437;

public class GroupList
extends ListScreenListBase<GroupEntry> {
    protected final ListScreenBase parent;

    public GroupList(ListScreenBase parent, int width, int height, int top, int itemSize) {
        super(width, height, top, itemSize);
        this.parent = parent;
        this.updateMembers();
    }

    public void updateMembers() {
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            this.method_25339();
            this.field_22740.method_1507(null);
            return;
        }
        boolean changed = false;
        LinkedList<GroupEntry> toRemove = new LinkedList<GroupEntry>();
        for (GroupEntry entry : this.method_25396()) {
            PlayerState state = ClientManager.getPlayerStateManager().getState(entry.getState().getUuid());
            if (state == null) {
                toRemove.add(entry);
                changed = true;
                continue;
            }
            entry.setState(state);
            if (this.isInGroup(state, group)) continue;
            toRemove.add(entry);
            changed = true;
        }
        for (GroupEntry entry : toRemove) {
            this.method_25330((class_350.class_351)entry);
        }
        for (PlayerState state : playerStates) {
            if (!this.isInGroup(state, group) || !this.method_25396().stream().noneMatch(groupEntry -> groupEntry.getState().getUuid().equals(state.getUuid()))) continue;
            this.method_25321((class_350.class_351)new GroupEntry(this.parent, state));
            changed = true;
        }
        if (changed) {
            this.method_25396().sort(Comparator.comparing(o -> o.getState().getName()));
        }
    }

    public static void update() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof GroupScreen) {
            GroupScreen groupScreen = (GroupScreen)class_4372;
            groupScreen.groupList.updateMembers();
        }
    }

    private boolean isInGroup(PlayerState state, UUID group) {
        return state.hasGroup() && state.getGroup().equals(group);
    }
}

