/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.fabric.mixin.impl;

import glitchcore.fabric.network.GCPayloadFactory;
import glitchcore.fabric.network.ICustomPayloadPacketHandler;
import glitchcore.network.CustomPacket;
import glitchcore.network.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.jodah.typetools.TypeResolver;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PacketHandler.class}, remap=false, priority=0)
public abstract class MixinPacketHandler
implements ICustomPayloadPacketHandler {
    @Shadow
    @Final
    private class_2960 channelName;
    @Unique
    private Map<Class<?>, GCPayloadFactory> factories = new HashMap();

    @Overwrite
    public <T extends CustomPacket<T>> void register(class_2960 name, CustomPacket<T> packet) {
        this.factories.put(MixinPacketHandler.getPacketDataType(packet), this.createPayloadFactory(name, packet));
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToPlayer(T packet, class_3222 player) {
        class_8710 payload = this.createCustomPacketPayload(packet);
        switch (packet.getPhase()) {
            case PLAY: {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Attempted to send packet with unsupported phase " + String.valueOf((Object)packet.getPhase()));
            }
        }
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToAll(T packet, MinecraftServer server) {
        class_8710 payload = this.createCustomPacketPayload(packet);
        switch (packet.getPhase()) {
            case PLAY: {
                server.method_3760().method_14581(ServerPlayNetworking.createS2CPacket((class_8710)payload));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Attempted to send packet with unsupported phase " + String.valueOf((Object)packet.getPhase()));
            }
        }
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToHandler(T packet, class_8610 handler) {
        class_8710 payload = this.createCustomPacketPayload(packet);
        switch (packet.getPhase()) {
            case CONFIGURATION: {
                ServerConfigurationNetworking.send((class_8610)handler, (class_8710)payload);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Attempted to send packet with unsupported phase " + String.valueOf((Object)packet.getPhase()));
            }
        }
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToServer(T packet) {
        throw new UnsupportedOperationException("Attempted to call sendToServer from server");
    }

    @Overwrite
    private void init() {
    }

    @Override
    public <T extends CustomPacket<T>> class_8710 createCustomPacketPayload(T packet) {
        Class<?> dataType = MixinPacketHandler.getPacketDataType(packet);
        if (!this.factories.containsKey(dataType)) {
            throw new RuntimeException("Unregistered packet of type " + String.valueOf(dataType));
        }
        return this.factories.get(dataType).createPayload(packet);
    }

    private static <T extends CustomPacket<T>> Class<?> getPacketDataType(CustomPacket<T> packet) {
        Class dataType = TypeResolver.resolveRawArgument(CustomPacket.class, packet.getClass());
        if (dataType == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Failed to resolve packet data type: " + String.valueOf(packet));
        }
        return dataType;
    }
}

