/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_8685;
import org.tlauncher.TLSkinCape;
import org.tlauncher.model.PlayerName;
import org.tlauncher.model.ProfileTexture;
import org.tlauncher.renderer.TextureManager;
import org.tlauncher.util.reflection.ResourceLocationUtils;

public class PlayerSkinManager {
    private static final class_8685[] DEFAULT_SKINS = new class_8685[]{PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/alex.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/ari.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/efe.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/kai.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/makena.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/noor.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/steve.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/sunny.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/slim/zuri.png", class_8685.class_7920.field_41122), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/alex.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/ari.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/efe.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/kai.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/makena.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/noor.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/steve.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/sunny.png", class_8685.class_7920.field_41123), PlayerSkinManager.createDefaultPlayerSkin("textures/entity/player/wide/zuri.png", class_8685.class_7920.field_41123)};
    private final TLSkinCape tlSkinCape;
    private final TextureManager textureManager;
    private final Map<PlayerName, PlayerDynamicSkin> playerSkins = new ConcurrentHashMap<PlayerName, PlayerDynamicSkin>();
    private final List<class_8685> emptySkins = Collections.unmodifiableList(new ArrayList());

    public class_8685 getPlayerSkin(GameProfile gameProfile, PlayerName playerName) {
        ProfileTexture profileTexture;
        boolean isSkinInit = this.textureManager.isInit(playerName, MinecraftProfileTexture.Type.SKIN);
        boolean isCapeInit = this.textureManager.isInit(playerName, MinecraftProfileTexture.Type.CAPE);
        PlayerDynamicSkin result = this.playerSkins.get(playerName);
        if (!isSkinInit || !isCapeInit) {
            if (this.tlSkinCape.createTexture(gameProfile, playerName)) {
                TLSkinCape.LOGGER.debug("TEXTURES creation started for PN:{} ||||| GP:{}", (Object)playerName, (Object)gameProfile);
            }
            return this.getRandomPlayerSkin(gameProfile);
        }
        if (result == null) {
            PlayerDynamicSkin skins;
            profileTexture = this.textureManager.get(playerName);
            if (profileTexture == null) {
                return this.getRandomPlayerSkin(gameProfile);
            }
            TLSkinCape.LOGGER.debug("LOADING GM:{} |||| PN:{}", (Object)gameProfile, (Object)playerName);
            result = skins = this.extractPlayerSkins(profileTexture);
            this.playerSkins.put(playerName, result);
        } else {
            profileTexture = this.textureManager.get(playerName);
            if (result.playerSkin() != null && !Objects.equals(result.playerSkin(), profileTexture.getSkin())) {
                this.playerSkins.remove(playerName);
                return this.getRandomPlayerSkin(gameProfile);
            }
        }
        if (profileTexture != null && profileTexture.getCape() != null) {
            if (profileTexture.getCape().getFrames().size() == 1) {
                return result.dynamicSkins().get(0);
            }
            profileTexture.getCape().getFrame();
            return result.dynamicSkins().get(profileTexture.getCape().getCurrentFrameIndex());
        }
        if (!result.dynamicSkins().isEmpty()) {
            return result.dynamicSkins().get(0);
        }
        return this.getRandomPlayerSkin(gameProfile);
    }

    private PlayerDynamicSkin extractPlayerSkins(ProfileTexture profileTexture) {
        if (profileTexture.getSkin() == null) {
            return new PlayerDynamicSkin(null, this.emptySkins);
        }
        class_8685.class_7920 model = "slim".equals(profileTexture.getSkinType()) ? class_8685.class_7920.field_41122 : class_8685.class_7920.field_41123;
        ArrayList<class_8685> skins = new ArrayList<class_8685>();
        boolean secure = false;
        if (profileTexture.getCape() != null) {
            for (class_2960 frame : profileTexture.getCape().getFrames()) {
                skins.add(new class_8685(profileTexture.getSkin(), null, frame, (class_2960)(profileTexture.isHasElytra() ? frame : null), model, secure));
            }
        } else {
            skins.add(new class_8685(profileTexture.getSkin(), null, null, null, model, secure));
        }
        return new PlayerDynamicSkin(profileTexture.getSkin(), skins);
    }

    private class_8685 getRandomPlayerSkin(GameProfile gameProfile) {
        return DEFAULT_SKINS[Math.floorMod(gameProfile.getId().hashCode(), DEFAULT_SKINS.length)];
    }

    private static class_8685 createDefaultPlayerSkin(String path, class_8685.class_7920 model) {
        return new class_8685(ResourceLocationUtils.resourceLocation(path), null, null, null, model, true);
    }

    public PlayerSkinManager(TLSkinCape tlSkinCape, TextureManager textureManager) {
        this.tlSkinCape = tlSkinCape;
        this.textureManager = textureManager;
    }

    private record PlayerDynamicSkin(class_2960 playerSkin, List<class_8685> dynamicSkins) {
    }
}

