/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7699;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class FurnitureDisplay
implements Display {
    public static final CategoryIdentifier<FurnitureDisplay> IDENTIFIER = CategoryIdentifier.of((class_2960)class_2960.method_60655((String)"pfm", (String)"furniture"));
    private int itemsPerInnerRecipe;
    public List<EntryIngredient> input;
    public List<EntryIngredient> output;
    public Optional<class_2960> location;
    public static final DisplaySerializer<FurnitureDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(FurnitureDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(FurnitureDisplay::getOutputEntries), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(FurnitureDisplay::getDisplayLocation), (App)Codec.INT.fieldOf("itemsPerInnerRecipe").forGetter(FurnitureDisplay::itemsPerInnerRecipe)).apply((Applicative)instance, FurnitureDisplay::new)), (class_9139)class_9139.method_56905((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), FurnitureDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), FurnitureDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), FurnitureDisplay::getDisplayLocation, (class_9139)class_9135.field_49675, FurnitureDisplay::itemsPerInnerRecipe, FurnitureDisplay::new));

    public FurnitureDisplay(class_8786<FurnitureRecipe> recipeEntry, class_7699 set) {
        this((FurnitureRecipe)recipeEntry.comp_1933(), set);
        this.location = Optional.of(recipeEntry.comp_1932().method_29177());
    }

    public FurnitureDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<class_2960> location, int itemsPerInnerRecipe) {
        this.input = input;
        this.output = output;
        this.location = location;
        this.itemsPerInnerRecipe = itemsPerInnerRecipe;
    }

    public FurnitureDisplay(FurnitureRecipe recipe, class_7699 set) {
        this.input = new ArrayList<EntryIngredient>();
        this.output = new ArrayList<EntryIngredient>();
        ArrayList inputEntries = new ArrayList();
        this.itemsPerInnerRecipe = recipe.getMaxInnerRecipeSize();
        for (FurnitureRecipe.CraftableFurnitureRecipe innerRecipe : recipe.getInnerRecipes(set)) {
            Map<class_1792, Integer> containedItems = innerRecipe.getItemCounts();
            ArrayList<EntryIngredient> finalList = new ArrayList<EntryIngredient>();
            for (Map.Entry<class_1792, Integer> entry : containedItems.entrySet()) {
                finalList.add(EntryIngredients.of((class_1799)new class_1799((class_1935)entry.getKey(), entry.getValue().intValue())));
            }
            finalList.sort(Comparator.comparing(entryStacks -> ((EntryStack)entryStacks.getFirst()).getValue().toString()));
            if (finalList.size() != this.itemsPerInnerRecipe) {
                while (finalList.size() != this.itemsPerInnerRecipe) {
                    finalList.add(EntryIngredient.empty());
                }
            }
            inputEntries.addAll(finalList);
        }
        this.input.addAll(inputEntries);
        this.output.addAll(recipe.getInnerRecipes(set).stream().map(FurnitureRecipe.CraftableFurnitureRecipe::getRecipeOuput).map(EntryIngredients::of).toList());
        this.location = Optional.empty();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public int itemsPerInnerRecipe() {
        return this.itemsPerInnerRecipe;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

