/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.ExtraCounterVariant;
import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3542;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4944;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ModelHelper {
    public static List<class_1058> OAK_SPRITES_PLANKS_TO_REPLACE = null;
    public static List<class_1058> OAK_SPRITES_BED_TO_REPLACE = null;
    public static List<class_1058> OAK_SPRITES_LOG_TOP_TO_REPLACE = null;
    public static final Map<Pair<String, String>, Pair<class_2960, Integer>> blockToTextureMap = new HashMap<Pair<String, String>, Pair<class_2960, Integer>>();
    private static final HashMap<class_2960, Boolean> idCacheMap = new HashMap();

    public static List<class_1058> getOakPlankLogSprites() {
        if (OAK_SPRITES_PLANKS_TO_REPLACE == null) {
            class_4730 planksId = new class_4730(class_1059.field_5275, class_2960.method_60654((String)"minecraft:block/oak_planks"));
            class_4730 logId = new class_4730(class_1059.field_5275, class_2960.method_60654((String)"minecraft:block/oak_log"));
            OAK_SPRITES_PLANKS_TO_REPLACE = Arrays.asList(planksId.method_24148(), logId.method_24148());
        }
        return OAK_SPRITES_PLANKS_TO_REPLACE;
    }

    public static List<class_1058> getOakBedSprites() {
        if (OAK_SPRITES_BED_TO_REPLACE == null) {
            class_4730 planksId = new class_4730(class_1059.field_5275, class_2960.method_60654((String)"minecraft:block/oak_planks"));
            class_4730 bedId = class_4722.method_65527((class_1767)class_1767.field_7964);
            OAK_SPRITES_BED_TO_REPLACE = Arrays.asList(planksId.method_24148(), bedId.method_24148());
        }
        return OAK_SPRITES_BED_TO_REPLACE;
    }

    public static List<class_1058> getOakLogLogTopSprites() {
        if (OAK_SPRITES_LOG_TOP_TO_REPLACE == null) {
            class_4730 logId = new class_4730(class_1059.field_5275, class_2960.method_60654((String)"minecraft:block/oak_log"));
            class_4730 logTopId = new class_4730(class_1059.field_5275, class_2960.method_60654((String)"minecraft:block/oak_log_top"));
            OAK_SPRITES_LOG_TOP_TO_REPLACE = Arrays.asList(logId.method_24148(), logTopId.method_24148());
        }
        return OAK_SPRITES_LOG_TOP_TO_REPLACE;
    }

    public static boolean containsIdentifier(class_2960[] modelIds, class_2960 comparison) {
        AtomicBoolean contains = new AtomicBoolean(false);
        Arrays.stream(modelIds).forEach(identifier -> {
            if (comparison.method_12832().equals(identifier.method_12832()) && comparison.method_12836().equals(identifier.method_12836())) {
                contains.set(true);
            }
        });
        return contains.get();
    }

    public static BlockType getBlockType(class_2960 identifier) {
        if (identifier.method_12832().contains("stripped_")) {
            return BlockType.STRIPPED_LOG;
        }
        for (WoodVariant variant : WoodVariantRegistry.getVariants()) {
            if (!identifier.method_12832().contains(variant.getPath())) continue;
            return BlockType.PLANKS;
        }
        return BlockType.BLOCK;
    }

    public static VariantBase<?> getVariant(class_2960 identifier) {
        VariantBase var = ModelHelper.getExtraCounterType(identifier);
        if (var == null) {
            var = ModelHelper.getStoneType(identifier);
        }
        if (var == null) {
            var = ModelHelper.getWoodType(identifier);
        }
        return var;
    }

    @Nullable
    public static ExtraCounterVariant getExtraCounterType(class_2960 identifier) {
        for (ExtraCounterVariant variant : ExtraCounterVariant.values()) {
            if (!identifier.method_12832().contains(variant.getPath()) || ModelHelper.getBlockType(identifier) != BlockType.BLOCK) continue;
            return variant;
        }
        return null;
    }

    @Nullable
    public static StoneVariant getStoneType(class_2960 identifier) {
        for (StoneVariant variant : StoneVariantRegistry.getVariants()) {
            if (!identifier.method_12832().contains(variant.getPath()) || ModelHelper.getBlockType(identifier) != BlockType.BLOCK) continue;
            return variant;
        }
        return null;
    }

    public static WoodVariant getWoodType(class_2960 identifier) {
        WoodVariant selectedVariant = null;
        for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
            if (!identifier.method_12832().contains(woodVariant.identifier.method_12832()) || identifier.method_12832().contains("dark") && !woodVariant.identifier.method_12832().contains("dark") || !identifier.method_12832().contains(woodVariant.getNamespace()) && !woodVariant.isVanilla()) continue;
            selectedVariant = woodVariant;
        }
        return selectedVariant != null ? selectedVariant : WoodVariantRegistry.OAK;
    }

    public static class_1767 getColor(class_2960 identifier) {
        Object object = class_7923.field_41175.method_63535(identifier);
        if (object instanceof DyeableFurnitureBlock) {
            DyeableFurnitureBlock block = (DyeableFurnitureBlock)object;
            return block.getPFMColor();
        }
        for (class_1767 color : class_1767.values()) {
            if (!identifier.method_12832().contains(color.method_7792()) || !identifier.method_12832().contains("light") && color.method_7792().contains("light") || identifier.method_12832().contains("light") && !color.method_7792().contains("light")) continue;
            return color;
        }
        return class_1767.field_7964;
    }

    public static class_2960 getVanillaConcreteColor(class_2960 identifier) {
        class_1767 color = ModelHelper.getColor(identifier);
        if (!identifier.method_12832().contains(color.method_7792())) {
            return class_2960.method_60655((String)"minecraft", (String)"block/white_concrete");
        }
        return class_2960.method_60655((String)"minecraft", (String)("block/" + color.method_7792() + "_concrete"));
    }

    public static class_2248 getWoolColor(String string) {
        class_2248 block = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60655((String)"minecraft", (String)(string + "_wool")));
        if (block != class_2246.field_10124) {
            return block;
        }
        return class_2246.field_10446;
    }

    public static class_2960 getTextureId(class_2248 block) {
        return ModelHelper.getTextureId(block, "");
    }

    public static class_2960 getTextureId(class_2248 block, String postfix) {
        class_1087 model;
        class_2960 id;
        Pair pair;
        if (postfix.isEmpty()) {
            postfix = null;
        }
        if (blockToTextureMap.containsKey(pair = new Pair((Object)block.toString(), (Object)postfix)) && (blockToTextureMap.get(pair).getFirst() != class_1047.method_4539() || (Integer)blockToTextureMap.get(pair).getSecond() > 3)) {
            return (class_2960)blockToTextureMap.get(pair).getFirst();
        }
        int attemptNum = 1;
        if (blockToTextureMap.containsKey(pair)) {
            attemptNum += ((Integer)blockToTextureMap.get(pair).getSecond()).intValue();
        }
        if (postfix == null) {
            postfix = "";
        }
        if (postfix.isEmpty() && !PFMDataGenerator.areAssetsRunning()) {
            List quadList;
            class_1087 model2 = class_310.method_1551().method_1554().method_4743().method_3335(block.method_9564());
            if (model2 != null && !(quadList = ((class_10889)model2.method_68512(class_5819.method_43049((long)42L)).getFirst()).method_68509(class_2350.field_11043)).isEmpty() && (id = ((class_777)quadList.get(0)).comp_3724().method_45851().method_45816()) != null && id != class_1047.method_4539()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<class_2960, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
        } else if (postfix.equals("_top") && !PFMDataGenerator.areAssetsRunning() && (model = class_310.method_1551().method_1554().method_4743().method_3335(block.method_9564())) != null) {
            List quadList = ((class_10889)model.method_68512(class_5819.method_43049((long)42L)).getFirst()).method_68509(class_2350.field_11036);
            if (!quadList.isEmpty() && (id = ((class_777)quadList.get(0)).comp_3724().method_45851().method_45816()) != null && id != class_1047.method_4539()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<class_2960, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
            quadList = ((class_10889)model.method_68512(class_5819.method_43049((long)42L)).getFirst()).method_68509(class_2350.field_11033);
            if (!quadList.isEmpty() && (id = ((class_777)quadList.get(0)).comp_3724().method_45851().method_45816()) != null && id != class_1047.method_4539()) {
                blockToTextureMap.put((Pair<String, String>)pair, (Pair<class_2960, Integer>)new Pair((Object)id, (Object)attemptNum));
                return id;
            }
        }
        if (ModelHelper.idExists(class_4944.method_25866((class_2248)block, (String)postfix), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25866((class_2248)block, (String)postfix);
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, postfix), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, postfix);
        } else if (ModelHelper.idExists(class_4944.method_25860((class_2248)block), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25860((class_2248)block);
        } else if (ModelHelper.idExists(class_4944.method_25866((class_2248)block, (String)"_side"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25866((class_2248)block, (String)"_side");
        } else if (ModelHelper.idExists(class_4944.method_25866((class_2248)block, (String)"_side_1"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25866((class_2248)block, (String)"_side_1");
        } else if (ModelHelper.idExists(class_4944.method_25866((class_2248)block, (String)"_bottom"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25866((class_2248)block, (String)"_bottom");
        } else if (ModelHelper.idExists(class_4944.method_25866((class_2248)block, (String)"_top"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25866((class_2248)block, (String)"_top");
        } else if (ModelHelper.idExists(class_4944.method_25866((class_2248)block, (String)"_middle"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = class_4944.method_25866((class_2248)block, (String)"_middle");
        } else if (ModelHelper.idExists(ModelHelper.getPlankId(block), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getPlankId(block);
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_side"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_side");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_side_1"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_side_1");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_top"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_top");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_middle"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_middle");
        } else if (ModelHelper.idExists(ModelHelper.getLogId(block, "_bottom"), class_3264.field_14188, IdLocation.TEXTURES)) {
            id = ModelHelper.getLogId(block, "_bottom");
        } else if (class_7923.field_41175.method_10221((Object)block).method_12836().equals("quark")) {
            id = class_4944.method_25866((class_2248)block, (String)postfix);
        } else {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't find texture for, {}, this is attempt {} at finding it", (Object)block, (Object)attemptNum);
            id = class_1047.method_4539();
        }
        blockToTextureMap.put((Pair<String, String>)pair, (Pair<class_2960, Integer>)new Pair((Object)id, (Object)attemptNum));
        return id;
    }

    public static class_2960 getPlankId(class_2248 block) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        String namespace = identifier.method_12836();
        Object path = identifier.method_12832().replace("luphie_", "");
        if (((String)path).contains("planks")) {
            class_2960 id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("_planks", "").replace("plank_", "")) + "/planks"));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            path = "planks_" + (String)path;
            if (namespace.contains("pixelmon") && ((String)path).contains("ultra")) {
                path = ((String)path).replace("ultra_", "").replace("_ultra", "");
                path = "ultra_space/" + (String)path;
            }
            if (namespace.equals("blue_skies")) {
                path = "wood/" + (String)path;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path));
            path = ((String)path).replace("mining", "mine").replace("sorting", "sort").replace("transformation", "trans").replace("dark", "darkwood").replace("alpha_", "alpha_oak_").replace("flowering_pink", "flowerypink").replace("flowering_purple", "floweringpurple");
            class_2960 id2 = class_2960.method_60655((String)namespace, (String)("block/wood/" + (String)path));
            class_2960 id3 = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "planks"));
            class_2960 id4 = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "_planks"));
            class_2960 id5 = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "plankstext"));
            class_2960 id6 = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "plankretext"));
            class_2960 id7 = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "_planks0"));
            class_2960 id8 = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks_", "") + "_planks1"));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            if (ModelHelper.idExists(id2, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id2;
            }
            if (ModelHelper.idExists(id3, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id3;
            }
            if (ModelHelper.idExists(id4, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id4;
            }
            if (ModelHelper.idExists(id5, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id5;
            }
            if (ModelHelper.idExists(id6, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id6;
            }
            if (ModelHelper.idExists(id7, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id7;
            }
            if (ModelHelper.idExists(id8, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id8;
            }
            return class_2960.method_60655((String)namespace, (String)("block/wood/" + (String)path + "_0"));
        }
        return class_2960.method_60655((String)namespace, (String)("block/" + (String)path));
    }

    public static class_2960 getLogId(class_2248 block, String postFix) {
        class_2960 id;
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        String namespace = identifier.method_12836();
        Object path = identifier.method_12832().replace("luphie_", "");
        if (namespace.contains("luphieclutteredmod") && ((String)path).contains("flowering_log")) {
            path = ((String)path).replace("flowering_log", "flowering_yellow_log");
        }
        if (namespace.contains("pixelmon") && ((String)path).contains("ultra")) {
            path = ((String)path).replace("ultra_", "").replace("_ultra", "");
            path = "ultra_space/" + (String)path;
        }
        if (namespace.equals("blue_skies")) {
            path = "wood/" + (String)path;
        }
        if (namespace.equals("byg") && ((String)path).contains("pedu")) {
            path = ((String)path).replace("pedu", "log");
        }
        if (((String)path).contains("log") || ((String)path).contains("stem")) {
            if (!((String)path).contains("_log")) {
                path = ((String)path).replace("log", "_log");
            }
            if (ModelHelper.idExists(id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path)), class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            path = ((String)path).replace("stem", "log").replace("log", "bark");
            path = (String)path + postFix;
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("stripped", "striped"))));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            path = ((String)path).replace("striped", "stripped");
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("bark", "log"))));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("stripped", "striped"))));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).contains("striped") ? "stripped_" + ((String)path).replace("_striped", "") : path)));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("stripped", "striped"))));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            String loc = identifier.method_12832().contains("stripped") || identifier.method_12832().contains("striped") ? "stripped_log" : "log";
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("striped_", "").replace(postFix, "").replace("_log", "")) + "/" + loc + postFix));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "/" + loc.replace("log", "stem") + postFix));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "/" + loc + "/" + postFix.replace("_", "")));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "/" + loc.replace("log", "stem") + "/" + postFix.replace("_", "")));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "/" + loc));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "/" + loc.replace("log", "stem")));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/stripped_" + (String)path + "_log"));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/stripped_" + (String)path + "_stem"));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "_log_stripped"));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)path + "_stem_stripped"));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
        } else if (((String)path).contains("reed")) {
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = ((String)path).replace("nether_", "").replace("reed", "reeds"))));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = (String)path + postFix)));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + ((String)path).replace("planks", "roof")));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
        }
        if (((String)path).contains("alpha_") && namespace.contains("regions")) {
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = !((String)path).contains("alpha_oak") ? ((String)path).replace("alpha", "alpha_oak") : path)));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/" + (String)(path = (String)path + postFix)));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)("block/alpha_oak_log" + postFix));
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
            id = class_2960.method_60655((String)namespace, (String)"block/alpha_oak_log");
            if (ModelHelper.idExists(id, class_3264.field_14188, IdLocation.TEXTURES)) {
                return id;
            }
        }
        return class_2960.method_60655((String)namespace, (String)("block/" + (String)path));
    }

    public static boolean idExists(class_2960 id, class_3264 resourceType, IdLocation idLocation) {
        if (idCacheMap.containsKey(id)) {
            return idCacheMap.get(id);
        }
        class_2960 id2 = class_2960.method_60655((String)id.method_12836(), (String)(idLocation.method_15434() + "/" + id.method_12832() + idLocation.getFileType()));
        AtomicBoolean exists = new AtomicBoolean(false);
        for (class_3262 rp : PFMRuntimeResources.RESOURCE_PACK_LIST) {
            if (exists.get()) break;
            rp.method_14408(resourceType, id2.method_12836(), id2.method_12832(), (identifier, supplier) -> {
                try {
                    ((InputStream)supplier.get()).read();
                    ((InputStream)supplier.get()).close();
                    exists.set(true);
                }
                catch (IOException e) {
                    exists.set(false);
                }
            });
        }
        idCacheMap.put(id, exists.get());
        return exists.get();
    }

    public static enum IdLocation implements class_3542
    {
        TEXTURES("textures", ".png"),
        MODELS("models"),
        BLOCKSTATES("blockstates"),
        RECIPES("recipes"),
        TAGS("tags"),
        LOOT_TABLES("loot_tables"),
        STRUCTURES("structures"),
        ADVANCEMENTS("advancements");

        private final String name;
        private final String fileType;

        private IdLocation(String name, String fileType) {
            this.name = name;
            this.fileType = fileType;
        }

        private IdLocation(String name) {
            this.name = name;
            this.fileType = ".json";
        }

        public String method_15434() {
            return this.name;
        }

        public String getFileType() {
            return this.fileType;
        }
    }
}

