/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryUtil;

public class ScreenQuad {
    public static ScreenQuad INSTANCE = new ScreenQuad();
    private static final float[] box_vertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    private GLVertexBuffer boxBuffer;
    private AbstractVertexAttribute va;
    private boolean init = false;

    private ScreenQuad() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.va = AbstractVertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexPointer.addVec2Pointer(false));
        this.va.completeAndCheck(8);
        this.createBuffer();
    }

    public void render() {
        this.init();
        this.boxBuffer.bind();
        this.va.bind();
        this.va.bindBufferToAllBindingPoints(this.boxBuffer.getId());
        GL32.glDrawArrays((int)4, (int)0, (int)6);
    }

    private void createBuffer() {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)(box_vertices.length * 4));
        buffer.asFloatBuffer().put(box_vertices);
        buffer.rewind();
        this.boxBuffer = new GLVertexBuffer(false);
        this.boxBuffer.bind();
        this.boxBuffer.uploadBuffer(buffer, box_vertices.length, EDhApiGpuUploadMethod.DATA, box_vertices.length * 4);
        MemoryUtil.memFree((Buffer)buffer);
    }
}

