/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.math;

import java.util.Objects;

public class UnitBytes {
    public final long value;

    public UnitBytes(long value) {
        this.value = value;
    }

    public long value() {
        return this.value;
    }

    public static long byteToGB(long v) {
        return v / 0x40000000L;
    }

    public static long byteToMB(long v) {
        return v / 0x100000L;
    }

    public static long byteToKB(long v) {
        return v / 1024L;
    }

    public static long GBToByte(long v) {
        return v * 0x40000000L;
    }

    public static long MBToByte(long v) {
        return v * 0x100000L;
    }

    public static long KBToByte(long v) {
        return v * 1024L;
    }

    public String toString() {
        long KB;
        long MB;
        long v = this.value;
        StringBuilder str = new StringBuilder();
        long GB = UnitBytes.byteToGB(v);
        if (GB != 0L) {
            str.append(GB).append("GB ");
        }
        if ((MB = UnitBytes.byteToMB(v -= UnitBytes.GBToByte(GB))) != 0L) {
            str.append(MB).append("MB ");
        }
        if ((KB = UnitBytes.byteToKB(v -= UnitBytes.MBToByte(MB))) != 0L) {
            str.append(KB).append("KB ");
        }
        str.append(v -= UnitBytes.KBToByte(KB)).append("B");
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitBytes unitBytes = (UnitBytes)o;
        return this.value == unitBytes.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

