/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.util;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import nl.enjarai.cicada.api.util.JsonSource;
import org.yaml.snakeyaml.Yaml;

public interface YamlSource {
    public static final YamlSource EMPTY = Optional::empty;
    public static final Yaml YAML = new Yaml();

    public static YamlSource fromString(String string) {
        return () -> Optional.of((Map)YAML.load(string));
    }

    public static YamlSource fromFile(String path) {
        return YamlSource.fromFile(Path.of(path, new String[0]));
    }

    public static YamlSource fromFile(Path path) {
        return () -> {
            try (BufferedReader in = Files.newBufferedReader(path);){
                Optional<Map> optional = Optional.of((Map)YAML.load((Reader)in));
                return optional;
            }
        };
    }

    public static YamlSource fromUrl(String url) {
        try {
            return YamlSource.fromUrl(new URL(url));
        }
        catch (MalformedURLException ignored) {
            return EMPTY;
        }
    }

    public static YamlSource fromUrl(URL url) {
        return () -> {
            URLConnection conn = url.openConnection();
            conn.connect();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                Optional<Map> optional = Optional.of((Map)YAML.load((Reader)in));
                return optional;
            }
        };
    }

    public static YamlSource fromResource(String path) {
        return () -> {
            InputStream resourceStream = JsonSource.class.getClassLoader().getResourceAsStream(path);
            if (resourceStream == null) {
                throw new IOException("Resource not found: " + path);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(resourceStream));){
                Optional<Map> optional = Optional.of((Map)YAML.load((Reader)in));
                return optional;
            }
        };
    }

    public Optional<Map<Object, Object>> get() throws IOException;

    default public Optional<Map<Object, Object>> getSafely(Consumer<Exception> errorHandler) {
        try {
            return this.get();
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            errorHandler.accept((Exception)e);
            return Optional.empty();
        }
    }

    default public Optional<Map<Object, Object>> getSilently() {
        return this.getSafely(e -> {});
    }

    default public YamlSource or(YamlSource other) {
        return () -> {
            Optional<Map<Object, Object>> thisYaml = this.getSilently();
            return thisYaml.isPresent() ? thisYaml : other.get();
        };
    }
}

