/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects;

import java.time.Duration;
import java.util.ArrayList;

public class EventTimer {
    long lastEventNs = -1L;
    public ArrayList<Event> events = new ArrayList();

    public EventTimer(String firstEventName) {
        this.lastEventNs = System.nanoTime();
        this.events.add(new Event(firstEventName));
    }

    public void nextEvent(String name) {
        long timeNs = System.nanoTime();
        if (this.lastEventNs != -1L && !this.events.isEmpty() && this.events.get((int)(this.events.size() - 1)).timeNs == -1L) {
            this.events.get((int)(this.events.size() - 1)).timeNs = timeNs - this.lastEventNs;
        }
        this.lastEventNs = timeNs;
        this.events.add(new Event(name));
    }

    public void complete() {
        long timeNs = System.nanoTime();
        if (this.lastEventNs != -1L && !this.events.isEmpty() && this.events.get((int)(this.events.size() - 1)).timeNs == -1L) {
            this.events.get((int)(this.events.size() - 1)).timeNs = timeNs - this.lastEventNs;
        }
        this.lastEventNs = -1L;
    }

    public long getEventTimeNs(String name) {
        for (Event e : this.events) {
            if (!e.name.equals(name)) continue;
            return e.timeNs;
        }
        return -1L;
    }

    public long getTotalTimeNs() {
        long total = 0L;
        for (Event e : this.events) {
            if (e.timeNs == -1L) continue;
            total += e.timeNs;
        }
        return total;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Event e : this.events) {
            if (e.timeNs != -1L) {
                sb.append(e.name).append(": ").append(Duration.ofNanos(e.timeNs)).append('\n');
                continue;
            }
            sb.append(e.name).append(": ").append("N/A").append('\n');
        }
        return sb.toString();
    }

    public static class Event {
        public long timeNs = -1L;
        public String name;

        Event(String name) {
            this.name = name;
        }
    }
}

