/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.model;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.tlauncher.TLSkinCape;
import org.tlauncher.model.MinecraftTexturesPayload1;

public class PlayerName {
    private final String displayName;
    private String name;
    private Map<MinecraftProfileTexture.Type, String> textureOwnerNames;
    private Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> nativeTextures;

    public PlayerName(String displayName) {
        this.displayName = displayName;
        this.name = displayName;
        this.setTextureOwnerName(null);
    }

    public PlayerName(GameProfile p) {
        this.displayName = StringUtils.isBlank((CharSequence)p.getName()) && Objects.nonNull(p.getId()) ? p.getId().toString() : p.getName();
        this.name = this.displayName;
        this.setTextureOwnerName(p);
    }

    private void setTextureOwnerName(GameProfile p) {
        MinecraftTexturesPayload1 texturesPayload;
        this.textureOwnerNames = new HashMap<MinecraftProfileTexture.Type, String>();
        for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
            this.textureOwnerNames.put(type, this.displayName);
        }
        if (p != null && (texturesPayload = this.getTexturesPayload(p)) != null && texturesPayload.getTextures() != null) {
            for (Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture> e : texturesPayload.getTextures().entrySet()) {
                this.textureOwnerNames.put(e.getKey(), texturesPayload.getProfileName());
            }
        }
    }

    private MinecraftTexturesPayload1 getTexturesPayload(GameProfile gameProfile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return null;
        }
        try {
            String json = new String(Base64.decodeBase64((String)textureProperty.value()), StandardCharsets.UTF_8);
            Gson g = new Gson();
            return (MinecraftTexturesPayload1)g.fromJson(json, MinecraftTexturesPayload1.class);
        }
        catch (JsonParseException e) {
            TLSkinCape.LOGGER.warn("Could not decode textures payload", (Throwable)e);
            return null;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerName that = (PlayerName)o;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.textureOwnerNames, that.textureOwnerNames);
    }

    public int hashCode() {
        return Objects.hash(this.displayName);
    }

    public String toString() {
        return "displayName=" + this.displayName + ", name=" + this.name;
    }

    public void fill(MinecraftTexturesPayload1 result) {
        if (Objects.isNull(result)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)result.getProfileName())) {
            this.setName(result.getProfileName());
        }
        if (Objects.nonNull(result.getTextures()) && !result.getTextures().isEmpty()) {
            this.nativeTextures = result.getTextures();
        }
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getNativeTextures() {
        return this.nativeTextures;
    }
}

