/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.widget;

import juuxel.adorn.client.gui.widget.ScissorEnvelope;
import juuxel.adorn.client.gui.widget.SizedElement;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.animation.AnimatedProperty;
import juuxel.adorn.util.animation.AnimatedPropertyWrapper;
import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.Interpolator;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public final class ScrollEnvelope
extends ScissorEnvelope {
    private static final double SHADOW_THRESHOLD = 1.0;
    private static final int GRADIENT_HEIGHT = 5;
    private static final int SCROLLING_SPEED = 20;
    private static final int GRADIENT_COLOR = Colors.color(0, 0.2f);
    private static final int SCROLLING_TRACK_MARGIN = 2;
    private static final int SCROLLING_TRACK_WIDTH = 4;
    private static final int SCROLL_THUMB_COLOR_INACTIVE = Colors.color(0, 0.2f);
    private static final int SCROLL_THUMB_COLOR_ACTIVE = Colors.color(0, 0.6f);
    private final SizedElement element;
    private double offset = 0.0;
    private final AnimatedPropertyWrapper<Double> animatedOffset;
    private final int trackHeight;
    private boolean draggingThumb = false;
    private double dragStart = 0.0;
    private boolean thumbHovered = false;
    private final AnimatedProperty<Integer> thumbColor;

    public ScrollEnvelope(int x, int y, int width, int height, SizedElement element, AnimationEngine animationEngine) {
        super(x, y, width, height);
        this.element = element;
        this.animatedOffset = new AnimatedPropertyWrapper<Double>(animationEngine, 50, Interpolator.DOUBLE, () -> this.offset, this::setOffset);
        this.trackHeight = height - 4;
        this.thumbColor = new AnimatedProperty<Integer>(SCROLL_THUMB_COLOR_INACTIVE, animationEngine, 20, Interpolator.COLOR);
    }

    private void setOffset(double offset) {
        this.offset = class_3532.method_15350((double)offset, (double)0.0, (double)this.heightDifference());
    }

    private int heightDifference() {
        return this.element.getHeight() - this.height;
    }

    private int thumbHeight() {
        return (int)((float)this.height / (float)this.element.getHeight() * (float)this.trackHeight);
    }

    private float coordToOffsetRatio() {
        return (float)(this.trackHeight - this.thumbHeight()) / (float)this.heightDifference();
    }

    private int thumbY() {
        return (int)(this.offset * (double)this.coordToOffsetRatio());
    }

    private boolean isMouseOverThumb(double mouseX, double mouseY) {
        if (this.heightDifference() > 0) {
            int thumbX = this.x + this.width - 2 - 4;
            int thumbStartY = this.y + 2 + this.thumbY();
            int thumbEndY = thumbStartY + this.thumbHeight();
            if ((double)thumbX <= mouseX && mouseX <= (double)(thumbX + 4) && (double)thumbStartY <= mouseY && mouseY <= (double)thumbEndY) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected class_364 current() {
        return this.element;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.isWithinScissor(mouseX, mouseY);
    }

    @Override
    protected boolean isMouseWithinScissorForInput(double x, double y) {
        return this.method_25405(x, y - this.offset);
    }

    @Override
    protected void renderContent(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.0, -this.offset, 0.0);
        super.renderContent(context, mouseX, (int)((double)mouseY + this.offset), delta);
        matrices.method_22909();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int heightDifference = this.heightDifference();
        if (heightDifference > 0) {
            boolean hovered;
            if ((double)heightDifference - this.offset >= 1.0) {
                context.method_25296(this.x, this.y + this.height - 5, this.x + this.width, this.y + this.height, 0, GRADIENT_COLOR);
            }
            if (this.offset >= 1.0) {
                context.method_25296(this.x, this.y, this.x + this.width, this.y + 5, GRADIENT_COLOR, 0);
            }
            boolean bl = hovered = this.draggingThumb || this.isMouseOverThumb(mouseX, mouseY);
            if (this.thumbHovered != hovered) {
                this.thumbHovered = hovered;
                this.thumbColor.set(hovered ? SCROLL_THUMB_COLOR_ACTIVE : SCROLL_THUMB_COLOR_INACTIVE);
            }
            int thumbX = this.x + this.width - 2 - 4;
            int thumbY = this.y + 2 + this.thumbY();
            context.method_25294(thumbX, thumbY, thumbX + 4, thumbY + this.thumbHeight(), this.thumbColor.get().intValue());
        }
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY + this.offset);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMouseOverThumb(mouseX, mouseY)) {
            this.draggingThumb = true;
            this.dragStart = mouseY - (double)(this.y + 2 + this.thumbY());
            return true;
        }
        return super.method_25402(mouseX, mouseY + this.offset, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingThumb) {
            double realY = mouseY - this.dragStart;
            double pos = class_3532.method_15350((double)class_3532.method_15370((double)realY, (double)(this.y + 2), (double)(this.y + 2 + this.trackHeight - this.thumbHeight())), (double)0.0, (double)1.0);
            this.setOffset(pos * (double)this.heightDifference());
            return true;
        }
        return super.method_25403(mouseX, mouseY + this.offset, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int heightDifference = this.heightDifference();
        if (heightDifference > 0) {
            this.animatedOffset.set(class_3532.method_15350((double)(this.offset - verticalAmount * 20.0), (double)0.0, (double)heightDifference));
        }
        return true;
    }

    @Override
    public void stopDragging() {
        super.stopDragging();
        this.draggingThumb = false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        int scrollAmount;
        switch (keyCode) {
            case 265: {
                int n = -20;
                break;
            }
            case 264: {
                int n = 20;
                break;
            }
            case 266: {
                int n = -this.height;
                break;
            }
            case 267: {
                int n = this.height;
                break;
            }
            default: {
                int n = scrollAmount = 0;
            }
        }
        if (scrollAmount != 0) {
            this.animatedOffset.set(this.animatedOffset.get() + (double)scrollAmount);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

