/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib.registry;

import java.util.function.BiFunction;
import java.util.function.Function;
import juuxel.adorn.item.BaseBlockItem;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_4970;

public final class RegistryHelper {
    private final Registrar<class_2248> blocks;
    private final Registrar<class_1792> items;

    public RegistryHelper(Registrar<class_2248> blocks, Registrar<class_1792> items) {
        this.blocks = blocks;
        this.items = items;
    }

    public <T extends class_2248> Registered<T> registerBlock(String name, Function<class_4970.class_2251, T> block, BlockSettingsProvider settings) {
        return this.registerBlock(name, ItemSettingsProvider.DEFAULT, block, settings);
    }

    public <T extends class_2248> Registered<T> registerBlock(String name, ItemSettingsProvider itemSettings, Function<class_4970.class_2251, T> block, BlockSettingsProvider settings) {
        return this.registerBlock(name, RegistryHelper::makeItemForBlock, itemSettings, block, settings);
    }

    public <T extends class_2248> Registered<T> registerBlock(String name, BiFunction<T, class_1792.class_1793, class_1792> itemProvider, Function<class_4970.class_2251, T> block, BlockSettingsProvider settings) {
        return this.registerBlock(name, itemProvider, ItemSettingsProvider.DEFAULT, block, settings);
    }

    public <T extends class_2248> Registered<T> registerBlock(String name, BiFunction<T, class_1792.class_1793, class_1792> itemProvider, ItemSettingsProvider itemSettings, Function<class_4970.class_2251, T> block, BlockSettingsProvider settings) {
        Registered registered = this.registerBlockWithoutItem(name, block, settings);
        this.items.register(name, key -> (class_1792)itemProvider.apply((class_2248)registered.get(), itemSettings.createItemSettings().method_63686(key).method_63685()));
        return registered;
    }

    public <T extends class_2248> Registered<T> registerBlockWithoutItem(String name, Function<class_4970.class_2251, T> block, BlockSettingsProvider settings) {
        return this.blocks.register(name, key -> (class_2248)block.apply(settings.createBlockSettings().method_63500(key)));
    }

    private static class_1792 makeItemForBlock(class_2248 block, class_1792.class_1793 itemSettings) {
        return new BaseBlockItem(block, itemSettings);
    }

    public <T extends class_1792> Registered<T> registerItem(String name, Function<class_1792.class_1793, T> factory) {
        return this.registerItem(name, factory, ItemSettingsProvider.DEFAULT);
    }

    public <T extends class_1792> Registered<T> registerItem(String name, Function<class_1792.class_1793, T> factory, ItemSettingsProvider settings) {
        return this.items.register(name, key -> (class_1792)factory.apply(settings.createItemSettings().method_63686(key)));
    }

    @FunctionalInterface
    public static interface ItemSettingsProvider {
        public static final ItemSettingsProvider DEFAULT = class_1792.class_1793::new;

        public class_1792.class_1793 createItemSettings();
    }

    @FunctionalInterface
    public static interface BlockSettingsProvider {
        public class_4970.class_2251 createBlockSettings();
    }
}

