/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

public final class Fractions {
    private static final char[] SUPERSCRIPTS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char[] SUBSCRIPTS = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};
    private static final char FRACTION_BAR = '\u2044';

    public static String toString(long numerator, long denominator) {
        if (denominator == 1L) {
            return Long.toString(numerator);
        }
        long realNumerator = numerator % denominator;
        long whole = (numerator - realNumerator) / denominator;
        return Fractions.toString(whole, realNumerator, denominator);
    }

    public static String toString(long whole, long numerator, long denominator) {
        StringBuilder sb = new StringBuilder();
        if (Fractions.sign(whole) * Fractions.sign(numerator) * Fractions.sign(denominator) == -1) {
            sb.append('-');
        }
        sb.append(Math.abs(whole));
        if (numerator != 0L) {
            sb.append(' ');
            for (int digit : Fractions.digits(numerator)) {
                sb.append(SUPERSCRIPTS[digit]);
            }
            sb.append('\u2044');
            for (int digit : Fractions.digits(denominator)) {
                sb.append(SUBSCRIPTS[digit]);
            }
        }
        return sb.toString();
    }

    private static int sign(long l) {
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    private static int[] digits(long l) {
        String str = Long.toString(Math.abs(l));
        int[] result = new int[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            assert ('0' <= c && c <= '9') : "Unknown digit character: " + c;
            result[i] = c - 48;
        }
        return result;
    }
}

