/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

public interface PropertyRef<T> {
    public String getName();

    public T get();

    public void set(T var1);

    public static <T> PropertyRef<T> ofField(final Object owner, String fieldName) {
        try {
            Field field = owner.getClass().getField(fieldName);
            field.setAccessible(true);
            final String name = field.getName();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            final MethodHandle getter = lookup.unreflectGetter(field);
            final MethodHandle setter = lookup.unreflectSetter(field);
            return new PropertyRef<T>(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public T get() {
                    try {
                        return getter.invoke(owner);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void set(T value) {
                    try {
                        setter.invoke(owner, value);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

