/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util.animation;

import java.util.Objects;
import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.AnimationTask;
import juuxel.adorn.util.animation.Interpolator;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnimatedProperty<T> {
    private final AnimationEngine engine;
    private final int duration;
    private final Interpolator<T> interpolator;
    @Nullable
    private Task currentTask = null;

    protected AbstractAnimatedProperty(AnimationEngine engine, int duration, Interpolator<T> interpolator) {
        this.engine = engine;
        this.duration = duration;
        this.interpolator = interpolator;
    }

    protected abstract void setRawValue(T var1);

    public abstract T get();

    public synchronized void set(T value) {
        T oldValue = this.get();
        Task oldTask = this.currentTask;
        if (oldTask != null) {
            this.engine.remove(oldTask);
        }
        if (!Objects.equals(oldValue, value)) {
            Task task;
            this.currentTask = task = new Task(oldValue, value);
            this.engine.add(task);
        }
    }

    private static float ease(float delta) {
        return 1.0f - (float)Math.pow(1.0f - delta, 5.0);
    }

    private final class Task
    implements AnimationTask {
        private final T from;
        private final T to;
        private int age = 0;

        private Task(T from, T to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean isAlive() {
            return this.age < AbstractAnimatedProperty.this.duration;
        }

        @Override
        public void tick() {
            ++this.age;
            float delta = AbstractAnimatedProperty.ease((float)this.age / (float)AbstractAnimatedProperty.this.duration);
            Object newValue = AbstractAnimatedProperty.this.interpolator.interpolate(delta, this.from, this.to);
            AbstractAnimatedProperty.this.setRawValue(newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removed() {
            AbstractAnimatedProperty abstractAnimatedProperty = AbstractAnimatedProperty.this;
            synchronized (abstractAnimatedProperty) {
                if (AbstractAnimatedProperty.this.currentTask == this) {
                    AbstractAnimatedProperty.this.currentTask = null;
                }
            }
        }
    }
}

