/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import java.util.Map;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.block.SneakClickHandler;
import juuxel.adorn.block.property.FrontConnection;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.util.Shapes;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SofaBlock
extends SeatBlock
implements class_3737,
SneakClickHandler,
BlockWithDescription {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 CONNECTED_LEFT = class_2746.method_11825((String)"connected_left");
    public static final class_2746 CONNECTED_RIGHT = class_2746.method_11825((String)"connected_right");
    public static final class_2754<FrontConnection> FRONT_CONNECTION = class_2754.method_11850((String)"front", FrontConnection.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265[] OUTLINE_SHAPES = SofaBlock.buildShapes(false);
    private static final class_265[] COLLISION_SHAPES = SofaBlock.buildShapes(true);
    private static final String DESCRIPTION_KEY = "block.adorn.sofa.description";

    public SofaBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FRONT_CONNECTION, (Comparable)((Object)FrontConnection.NONE))).method_11657((class_2769)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_2960 getSittingStat() {
        return AdornStats.SIT_ON_SOFA;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dye = (class_1769)class_17922;
            world.method_8501(pos, AdornBlocks.SOFAS.getEager(dye.method_7802()).method_34725(state));
            world.method_8396((class_1297)player, pos, class_3417.field_15226, class_3419.field_15245, 1.0f, 0.8f);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            if (!world.field_9236) {
                player.method_7281(AdornStats.DYE_SOFA);
            }
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public class_1269 onSneakClick(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2350 sleepingDirection = SofaBlock.getSleepingDirection((class_1922)world, pos);
        if (((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.adorn.sofa.occupied"), true);
            return class_1269.field_5812;
        }
        if (class_2244.method_27352((class_1937)world) && sleepingDirection != null) {
            if (!world.field_9236) {
                player.method_7269(pos).ifLeft(reason -> {
                    if (reason.method_19206() != null) {
                        player.method_7353(reason.method_19206(), true);
                    }
                });
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, CONNECTED_LEFT, CONNECTED_RIGHT, FRONT_CONNECTION, WATERLOGGED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.updateConnections((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910)), (class_1922)ctx.method_8045(), ctx.method_8037());
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return this.updateConnections(state, (class_1922)world, pos);
    }

    private class_2680 updateConnections(class_2680 state, class_1922 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        class_2680 leftState = world.method_8320(pos.method_10093(direction.method_10170()));
        class_2680 rightState = world.method_8320(pos.method_10093(direction.method_10160()));
        class_2680 frontState = world.method_8320(pos.method_10093(direction));
        boolean connectedLeft = leftState.method_26204() instanceof SofaBlock && (leftState.method_11654(FACING) == direction || leftState.method_11654(FACING) == direction.method_10160() && leftState.method_11654(FRONT_CONNECTION) != FrontConnection.NONE);
        boolean connectedRight = rightState.method_26204() instanceof SofaBlock && (rightState.method_11654(FACING) == direction || rightState.method_11654(FACING) == direction.method_10170() && rightState.method_11654(FRONT_CONNECTION) != FrontConnection.NONE);
        boolean connectedFront = frontState.method_26204() instanceof SofaBlock;
        boolean connectedFrontLeft = connectedFront && !connectedLeft && frontState.method_11654(FACING) == direction.method_10160();
        boolean connectedFrontRight = connectedFront && !connectedRight && frontState.method_11654(FACING) == direction.method_10170();
        FrontConnection frontConnection = FrontConnection.NONE;
        if (connectedFrontLeft) {
            frontConnection = FrontConnection.LEFT;
        } else if (connectedFrontRight) {
            frontConnection = FrontConnection.RIGHT;
        }
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)CONNECTED_LEFT, (Comparable)Boolean.valueOf(connectedLeft))).method_11657((class_2769)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connectedRight))).method_11657(FRONT_CONNECTION, (Comparable)((Object)frontConnection));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPES[SofaBlock.getShapeKey((class_2350)state.method_11654(FACING), (Boolean)state.method_11654((class_2769)CONNECTED_LEFT), (Boolean)state.method_11654((class_2769)CONNECTED_RIGHT), (FrontConnection)((Object)state.method_11654(FRONT_CONNECTION)))];
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES[SofaBlock.getShapeKey((class_2350)state.method_11654(FACING), (Boolean)state.method_11654((class_2769)CONNECTED_LEFT), (Boolean)state.method_11654((class_2769)CONNECTED_RIGHT), (FrontConnection)((Object)state.method_11654(FRONT_CONNECTION)))];
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    @Override
    public double getSittingOffset(class_1937 world, class_2680 state, class_2338 pos) {
        return 0.4375;
    }

    @Override
    public class_2350 getPreferredDismountDirection(class_2680 state, class_1297 passenger) {
        return (class_2350)state.method_11654(FACING);
    }

    private static class_265[] buildShapes(boolean thin) {
        class_265 bottom = SofaBlock.method_9541((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
        Map<class_2350, class_265> leftArms = Shapes.buildShapeRotations(5, 7, 13, 16, 13, 16);
        Map<class_2350, class_265> rightArms = Shapes.buildShapeRotations(5, 7, 0, 16, 13, 3);
        Map<class_2350, class_265> thinLeftArms = Shapes.buildShapeRotations(5, 7, 14, 16, 13, 16);
        Map<class_2350, class_265> thinRightArms = Shapes.buildShapeRotations(5, 7, 0, 16, 13, 2);
        Map<class_2350, class_265> backs = Shapes.buildShapeRotations(0, 7, 0, 5, 16, 16);
        Map<class_2350, class_265> leftCorners = Shapes.buildShapeRotations(5, 7, 11, 16, 16, 16);
        Map<class_2350, class_265> rightCorners = Shapes.buildShapeRotations(5, 7, 0, 16, 16, 5);
        boolean[] booleans = new boolean[]{true, false};
        class_265[] result = new class_265[48];
        for (class_2350 facing : FACING.method_11898()) {
            for (boolean left : booleans) {
                for (boolean right : booleans) {
                    for (FrontConnection front : FRONT_CONNECTION.method_11898()) {
                        class_265 shape;
                        ArrayList<class_265> parts = new ArrayList<class_265>();
                        parts.add(backs.get(facing));
                        if (!left && front == FrontConnection.NONE) {
                            parts.add(thin ? thinLeftArms.get(facing) : leftArms.get(facing));
                        }
                        if (!right && front == FrontConnection.NONE) {
                            parts.add(thin ? thinRightArms.get(facing) : rightArms.get(facing));
                        }
                        switch (front) {
                            case LEFT: {
                                parts.add(leftCorners.get(facing));
                                break;
                            }
                            case RIGHT: {
                                parts.add(rightCorners.get(facing));
                            }
                        }
                        int key = SofaBlock.getShapeKey(facing, left, right, front);
                        result[key] = shape = class_259.method_17786((class_265)bottom, (class_265[])((class_265[])parts.toArray(class_265[]::new)));
                    }
                }
            }
        }
        return result;
    }

    private static int getShapeKey(class_2350 facing, boolean left, boolean right, FrontConnection front) {
        return front.ordinal() << 4 | (left ? 1 : 0) << 3 | (right ? 1 : 0) << 2 | facing.method_10161();
    }

    @Nullable
    public static class_2350 getSleepingDirection(class_1922 world, class_2338 pos) {
        return SofaBlock.getSleepingDirection(world, pos, false);
    }

    @Nullable
    public static class_2350 getSleepingDirection(class_1922 world, class_2338 pos, boolean ignoreNeighbors) {
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof SofaBlock)) {
            return null;
        }
        boolean connectedLeft = (Boolean)state.method_11654((class_2769)CONNECTED_LEFT);
        boolean connectedRight = (Boolean)state.method_11654((class_2769)CONNECTED_RIGHT);
        FrontConnection frontConnection = (FrontConnection)((Object)state.method_11654(FRONT_CONNECTION));
        class_2350 facing = (class_2350)state.method_11654(FACING);
        if (!connectedLeft && !connectedRight && frontConnection == FrontConnection.NONE || !ignoreNeighbors && ((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
            return null;
        }
        @Nullable Object result = frontConnection != FrontConnection.NONE ? facing : (connectedLeft ? facing.method_10170() : (connectedRight ? facing.method_10160() : null));
        if (result != null) {
            if (ignoreNeighbors) {
                return result;
            }
            class_2680 neighborState = world.method_8320(pos.method_10093(result));
            if (neighborState.method_26204() instanceof SofaBlock && !((Boolean)neighborState.method_11654((class_2769)OCCUPIED)).booleanValue()) {
                return result;
            }
        }
        return null;
    }
}

