/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.util.FluidStorageReference;
import juuxel.adorn.util.NbtUtil;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class KitchenSinkBlockEntityFabric
extends KitchenSinkBlockEntity {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    BlockApiLookup.BlockApiProvider<Storage<FluidVariant>, @Nullable class_2350> FLUID_STORAGE_PROVIDER = (world, pos, state, blockEntity, context) -> {
        if (blockEntity instanceof KitchenSinkBlockEntityFabric) {
            KitchenSinkBlockEntityFabric kitchenSink = (KitchenSinkBlockEntityFabric)blockEntity;
            return kitchenSink.storage;
        }
        return null;
    };
    private static final String NBT_FLUID = "Fluid";
    private static final String NBT_VOLUME = "Volume";
    private final SingleVariantStorage<FluidVariant> storage = new SingleVariantStorage<FluidVariant>(){

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            return super.extract((TransferVariant)extractedVariant, maxAmount, transaction);
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected void onFinalCommit() {
            KitchenSinkBlockEntityFabric.this.markDirtyAndSync();
        }
    };
    private final FluidReference fluidReference = new FluidStorageReference(this.storage);

    public KitchenSinkBlockEntityFabric(class_2338 pos, class_2680 state) {
        super(pos, state);
    }

    public SingleVariantStorage<FluidVariant> getStorage() {
        return this.storage;
    }

    @Override
    public FluidReference getFluidReference() {
        return this.fluidReference;
    }

    @Override
    public boolean interactWithItem(class_1799 stack, class_1657 player, class_1268 hand) {
        long moved;
        boolean hasSpace;
        class_1799 originalStack = stack.method_7972();
        Storage itemStorage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.forPlayerInteraction((class_1657)player, (class_1268)hand));
        if (itemStorage == null) {
            return false;
        }
        boolean bl = hasSpace = this.storage.amount < this.storage.getCapacity();
        if (hasSpace && (moved = StorageUtil.move((Storage)itemStorage, this.storage, (Predicate)Predicates.alwaysTrue(), (long)Long.MAX_VALUE, null)) > 0L) {
            this.onFill(originalStack, player);
            this.markDirtyAndSync();
            return true;
        }
        FluidVolume fluid = this.fluidReference.createSnapshot();
        long moved2 = StorageUtil.move(this.storage, (Storage)itemStorage, (Predicate)Predicates.alwaysTrue(), (long)Long.MAX_VALUE, null);
        if (moved2 > 0L) {
            this.onPickUp(fluid, originalStack, player);
            this.markDirtyAndSync();
            return true;
        }
        return false;
    }

    @Override
    public boolean clearFluidsWithSponge() {
        if (!((FluidVariant)this.storage.variant).getFluid().method_15791(class_3486.field_15517) || this.storage.amount == 0L) {
            return false;
        }
        this.storage.amount = 0L;
        this.markDirtyAndSync();
        return true;
    }

    @Override
    protected KitchenSinkBlockEntity.FluidItemSound getFillSound(FluidReference fluid, class_1799 stack) {
        return super.getFillSound(fluid, stack).orElse(FluidVariantAttributes.getFillSound((FluidVariant)FluidStorageReference.toFluidVariant(fluid)));
    }

    @Override
    protected KitchenSinkBlockEntity.FluidItemSound getEmptySound(FluidReference fluid, class_1799 stack) {
        return super.getEmptySound(fluid, stack).orElse(FluidVariantAttributes.getEmptySound((FluidVariant)FluidStorageReference.toFluidVariant(fluid)));
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.storage.variant = (TransferVariant)NbtUtil.getWithCodec(nbt, NBT_FLUID, FluidVariant.CODEC, registries);
        this.storage.amount = nbt.method_68080(NBT_VOLUME, 0L);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        NbtUtil.putWithCodec(nbt, NBT_FLUID, FluidVariant.CODEC, (FluidVariant)this.storage.variant, registries);
        nbt.method_10544(NBT_VOLUME, this.storage.amount);
    }

    @Override
    public int calculateComparatorOutput() {
        if (this.storage.amount == 0L) {
            return 0;
        }
        return 1 + class_3532.method_15357((double)(14.0 * (double)this.storage.amount / (double)this.storage.getCapacity()));
    }
}

