/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import juuxel.adorn.client.book.Image;
import juuxel.adorn.util.EntryOrTag;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public record Page(List<Icon> icons, class_2561 title, class_2561 text, @Nullable Image image) {
    public static final Codec<Page> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Icon.CODEC.listOf().fieldOf("icons").forGetter(Page::icons), (App)class_8824.field_46597.fieldOf("title").forGetter(Page::title), (App)class_8824.field_46597.optionalFieldOf("text", (Object)class_2561.method_43473()).forGetter(Page::text), (App)Image.CODEC.optionalFieldOf("image").forGetter(page -> Optional.ofNullable(page.image))).apply((Applicative)instance, Page::new));

    private Page(List<Icon> icons, class_2561 title, class_2561 text, Optional<Image> image) {
        this(icons, title, text, (Image)image.orElse(null));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Icon> icons = new ArrayList<Icon>();
        @Nullable
        private class_2561 title;
        @Nullable
        private class_2561 text;
        @Nullable
        private Image image;

        private Builder() {
        }

        public Builder icon(class_1935 item) {
            this.icons.add(new Icon(new EntryOrTag.OfEntry<class_1792>(item.method_8389())));
            return this;
        }

        public Builder icon(class_6862<class_1792> tag) {
            this.icons.add(new Icon(new EntryOrTag.OfTag<class_1792>(tag)));
            return this;
        }

        public Builder title(class_2561 title) {
            this.title = title;
            return this;
        }

        public Builder content(class_2561 text) {
            this.text = text;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public Page build() {
            if (this.icons.isEmpty()) {
                throw new IllegalArgumentException("Page has no icons");
            }
            Objects.requireNonNull(this.title);
            Objects.requireNonNull(this.text);
            return new Page(this.icons, this.title, this.text, this.image);
        }
    }

    public record Icon(EntryOrTag<class_1792> items) {
        public static final Codec<Icon> CODEC = EntryOrTag.codec(class_7924.field_41197).xmap(Icon::new, Icon::items);

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<class_1799> createStacks() {
            List<Object> list;
            EntryOrTag<class_1792> entryOrTag = this.items;
            Objects.requireNonNull(entryOrTag);
            EntryOrTag<class_1792> entryOrTag2 = entryOrTag;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntryOrTag.OfEntry.class, EntryOrTag.OfTag.class}, entryOrTag2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    class_1792 item;
                    EntryOrTag.OfEntry ofEntry = (EntryOrTag.OfEntry)entryOrTag2;
                    try {
                        class_1792 class_17922;
                        item = class_17922 = (class_1792)ofEntry.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    list = List.of(item.method_7854());
                    return list;
                }
                case 1: 
            }
            EntryOrTag.OfTag ofTag = (EntryOrTag.OfTag)entryOrTag2;
            {
                class_6862 class_68622;
                class_6862 tag = class_68622 = ofTag.tag();
                list = class_7923.field_41178.method_46733(tag).map(entries -> {
                    ArrayList<class_1799> result = new ArrayList<class_1799>(entries.method_40247());
                    for (class_6880 entry : entries) {
                        result.add(((class_1792)entry.comp_349()).method_7854());
                    }
                    return result;
                }).orElse(List.of());
            }
            return list;
        }
    }
}

