/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import java.util.List;
import java.util.Objects;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.book.Book;
import juuxel.adorn.client.book.Image;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.client.gui.Scissors;
import juuxel.adorn.client.gui.widget.Draggable;
import juuxel.adorn.client.gui.widget.FlipBook;
import juuxel.adorn.client.gui.widget.Panel;
import juuxel.adorn.client.gui.widget.ScrollEnvelope;
import juuxel.adorn.client.gui.widget.SizedElement;
import juuxel.adorn.client.gui.widget.TickingElement;
import juuxel.adorn.util.CollectionUtil;
import juuxel.adorn.util.animation.AnimationEngine;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_474;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public final class GuideBookScreen
extends class_437 {
    private static final int BOOK_SIZE = 192;
    private static final int PAGE_TITLE_X = 20;
    private static final int PAGE_WIDTH = 116;
    private static final int PAGE_BODY_HEIGHT = 121;
    private static final int PAGE_TITLE_WIDTH = 76;
    private static final int PAGE_TEXT_X = 4;
    private static final int PAGE_TEXT_Y = 24;
    private static final int PAGE_IMAGE_GAP = 4;
    private static final int ICON_DURATION = 25;
    private static final class_2960 CLOSE_BOOK_ACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_active.png");
    private static final class_2960 CLOSE_BOOK_INACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_inactive.png");
    private static final int HOVER_AREA_HIGHLIGHT_COLOR = -2130706433;
    private final Book book;
    private FlipBook flipBook;
    private class_474 previousPageButton;
    private class_474 nextPageButton;
    private final AnimationEngine animationEngine = new AnimationEngine();

    public GuideBookScreen(Book book) {
        super(class_5244.field_39003);
        this.book = book;
    }

    protected void method_25426() {
        int x = (this.field_22789 - 192) / 2;
        int y = (this.field_22790 - 192) / 2;
        int pageX = x + 35;
        int pageY = y + 14;
        this.method_37063((class_364)new CloseButton(this, x + 142, y + 14, button -> this.method_25419()));
        this.previousPageButton = (class_474)this.method_37063((class_364)new class_474(x + 49, y + 159, false, widget -> this.flipBook.showPreviousPage(), true));
        this.nextPageButton = (class_474)this.method_37063((class_364)new class_474(x + 116, y + 159, true, widget -> this.flipBook.showNextPage(), true));
        this.flipBook = (FlipBook)this.method_37063(new FlipBook(this::updatePageTurnButtons));
        this.flipBook.add(new TitlePage(pageX, pageY));
        for (Page page : this.book.pages()) {
            Panel panel = new Panel();
            panel.add(new BookPageTitle(pageX, pageY, page));
            BookPageBody body = new BookPageBody(pageX, pageY + 24, page);
            panel.add(new ScrollEnvelope(pageX, pageY + 24, 116, 121, body, this.animationEngine));
            this.flipBook.add((class_364)panel);
        }
        this.updatePageTurnButtons();
        this.animationEngine.start();
    }

    private void updatePageTurnButtons() {
        this.previousPageButton.field_22764 = this.flipBook.hasPreviousPage();
        this.nextPageButton.field_22764 = this.flipBook.hasNextPage();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        int x = (this.field_22789 - 192) / 2;
        int y = (this.field_22790 - 192) / 2;
        context.method_25290(class_1921::method_62277, class_3872.field_17117, x, y, 0.0f, 0.0f, 192, 192, 256, 256);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_25430(@Nullable class_2583 style) {
        class_2558 clickEvent;
        if (style == null || !((clickEvent = style.method_10970()) instanceof class_2558.class_10605)) return super.method_25430(style);
        class_2558.class_10605 class_106052 = (class_2558.class_10605)clickEvent;
        try {
            int n;
            int page = n = class_106052.comp_3502();
            int pageIndex = page - 1;
            if (0 > pageIndex || pageIndex >= this.flipBook.getPageCount()) return super.method_25430(style);
            this.flipBook.setCurrentPage(pageIndex);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
        return true;
    }

    public void method_25393() {
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof TickingElement)) continue;
            TickingElement ticking = (TickingElement)child;
            ticking.tick();
        }
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof Draggable) {
            Draggable focused = (Draggable)class_3642;
            if (!this.method_25397()) {
                focused.stopDragging();
            }
        }
    }

    public void method_25432() {
        this.animationEngine.stop();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        class_364 class_3642 = this.flipBook.getCurrentPageValue();
        if (class_3642 instanceof Panel) {
            Panel currentPage = (Panel)class_3642;
            for (class_364 class_3643 : currentPage.method_25396()) {
                if (!(class_3643 instanceof ScrollEnvelope)) continue;
                return class_3643.method_25404(keyCode, scanCode, modifiers);
            }
        }
        return false;
    }

    private final class CloseButton
    extends class_4185 {
        private CloseButton(GuideBookScreen guideBookScreen, int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 8, 8, class_5244.field_39003, onPress, field_40754);
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2960 texture = this.method_49606() ? CLOSE_BOOK_ACTIVE_TEXTURE : CLOSE_BOOK_INACTIVE_TEXTURE;
            context.method_25290(class_1921::method_62277, texture, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    private final class TitlePage
    implements class_364,
    class_4068 {
        private final int x;
        private final int y;
        private final class_2561 byAuthor;
        private boolean focused;

        private TitlePage(int x, int y) {
            this.byAuthor = class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{GuideBookScreen.this.book.author()});
            this.focused = false;
            this.x = x;
            this.y = y;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            int cx = this.x + 58;
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_22904((double)cx, (double)(this.y + 7 + 25), 0.0);
            matrices.method_22905(GuideBookScreen.this.book.titleScale(), GuideBookScreen.this.book.titleScale(), 1.0f);
            context.method_51439(GuideBookScreen.this.field_22793, GuideBookScreen.this.book.title(), -GuideBookScreen.this.field_22793.method_27525((class_5348)GuideBookScreen.this.book.title()) / 2, 0, -12566464, false);
            matrices.method_22909();
            context.method_51439(GuideBookScreen.this.field_22793, GuideBookScreen.this.book.subtitle(), cx - GuideBookScreen.this.field_22793.method_27525((class_5348)GuideBookScreen.this.book.subtitle()) / 2, this.y + 45, -12566464, false);
            context.method_51439(GuideBookScreen.this.field_22793, this.byAuthor, cx - GuideBookScreen.this.field_22793.method_27525((class_5348)this.byAuthor) / 2, this.y + 60, -12566464, false);
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }
    }

    private final class BookPageTitle
    implements class_364,
    class_4068,
    TickingElement {
        private final int x;
        private final int y;
        private final List<class_5481> wrappedTitleLines;
        private final List<class_1799> icons;
        private int icon = 0;
        private int iconTicks = 0;
        private boolean focused = false;

        private BookPageTitle(int x, int y, Page page) {
            this.x = x;
            this.y = y;
            this.wrappedTitleLines = GuideBookScreen.this.field_22793.method_1728((class_5348)page.title().method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true))), 76);
            this.icons = CollectionUtil.interleave(page.icons().stream().map(Page.Icon::createStacks).toList());
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51445(this.icons.get(this.icon), this.x, this.y);
            Objects.requireNonNull(GuideBookScreen.this.field_22793);
            int titleY = this.y + 10 - 9 * this.wrappedTitleLines.size() / 2;
            for (int i = 0; i < this.wrappedTitleLines.size(); ++i) {
                class_5481 line = this.wrappedTitleLines.get(i);
                class_327 class_3272 = GuideBookScreen.this.field_22793;
                Objects.requireNonNull(GuideBookScreen.this.field_22793);
                context.method_51430(class_3272, line, this.x + 20, titleY + i * 9, -12566464, false);
            }
        }

        @Override
        public void tick() {
            if (this.iconTicks++ >= 25) {
                this.iconTicks = 0;
                this.icon = (this.icon + 1) % this.icons.size();
            }
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }
    }

    private final class BookPageBody
    implements SizedElement,
    class_4068 {
        private final int x;
        private final int y;
        private final Page page;
        private final List<class_5481> wrappedBodyLines;
        private final int textHeight;
        private final int imageHeight;
        private final int height;
        private boolean focused;

        private BookPageBody(int x, int y, Page page) {
            this.x = x;
            this.y = y;
            this.page = page;
            this.wrappedBodyLines = GuideBookScreen.this.field_22793.method_1728((class_5348)page.text(), 112);
            int n = this.wrappedBodyLines.size();
            Objects.requireNonNull(GuideBookScreen.this.field_22793);
            this.textHeight = n * 9;
            this.imageHeight = page.image() != null ? page.image().size().y() + 4 : 0;
            this.height = Math.max(121, this.textHeight + this.imageHeight);
        }

        @Override
        public int getWidth() {
            return 116;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return (double)this.x <= mouseX && mouseX <= (double)(this.x + GuideBookScreen.this.field_22789) && (double)this.y <= mouseY && mouseY <= (double)(this.y + this.height);
        }

        @Nullable
        private class_2583 getTextStyleAt(int x, int y) {
            if (!this.method_25405(x, y)) {
                return null;
            }
            int wx = x - (this.x + 4);
            int wy = y - this.y;
            Objects.requireNonNull(GuideBookScreen.this.field_22793);
            int lineIndex = wy / 9;
            if (0 <= lineIndex && lineIndex < this.wrappedBodyLines.size()) {
                class_5481 line = this.wrappedBodyLines.get(lineIndex);
                return GuideBookScreen.this.field_22793.method_27527().method_30876(line, wx);
            }
            return null;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            int textYOffset = this.page.image() != null && this.page.image().placement() == Image.Placement.BEFORE_TEXT ? this.imageHeight : 0;
            for (int i = 0; i < this.wrappedBodyLines.size(); ++i) {
                class_5481 line = this.wrappedBodyLines.get(i);
                class_327 class_3272 = GuideBookScreen.this.field_22793;
                Objects.requireNonNull(GuideBookScreen.this.field_22793);
                context.method_51430(class_3272, line, this.x + 4, textYOffset + this.y + i * 9, -12566464, false);
            }
            if (this.page.image() != null) {
                this.renderImage(context, this.page.image(), mouseX, mouseY);
            }
            class_2583 hoveredStyle = this.getTextStyleAt(mouseX, mouseY);
            Scissors.suspendScissors(context, () -> context.method_51441(GuideBookScreen.this.field_22793, hoveredStyle, mouseX, mouseY));
        }

        private void renderImage(class_332 context, Image image, int mouseX, int mouseY) {
            int imageX = this.x + (116 - image.size().x()) / 2;
            int imageY = switch (image.placement()) {
                default -> throw new MatchException(null, null);
                case Image.Placement.BEFORE_TEXT -> this.y;
                case Image.Placement.AFTER_TEXT -> this.y + this.textHeight + 4;
            };
            context.method_25290(class_1921::method_62277, image.location(), imageX, imageY, 0.0f, 0.0f, image.size().x(), image.size().y(), image.size().x(), image.size().y());
            for (Image.HoverArea hoverArea : image.hoverAreas()) {
                if (!hoverArea.contains(mouseX - imageX, mouseY - imageY)) continue;
                int hX = imageX + hoverArea.position().x();
                int hY = imageY + hoverArea.position().y();
                context.method_25294(hX, hY, hX + hoverArea.size().x(), hY + hoverArea.size().y(), -2130706433);
                List wrappedTooltip = GuideBookScreen.this.field_22793.method_1728((class_5348)hoverArea.tooltip(), 116);
                Scissors.suspendScissors(context, () -> context.method_51447(GuideBookScreen.this.field_22793, wrappedTooltip, mouseX, mouseY));
                break;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            class_2583 style;
            if (button == 0 && (style = this.getTextStyleAt((int)mouseX, (int)mouseY)) != null && GuideBookScreen.this.method_25430(style)) {
                return true;
            }
            return SizedElement.super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }
    }
}

