/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import java.util.Objects;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9326;

public abstract class FluidReference
implements HasFluidAmount {
    public abstract class_3611 getFluid();

    public abstract void setFluid(class_3611 var1);

    public abstract void setAmount(long var1);

    public abstract class_9326 getComponents();

    public abstract void setComponents(class_9326 var1);

    public boolean isEmpty() {
        return this.getFluid() == class_3612.field_15906 || this.getAmount() == 0L;
    }

    public void write(class_9129 buf) {
        buf.method_10817((Enum)this.getUnit());
        if (this.isEmpty()) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            buf.method_10804(class_7923.field_41173.method_10206((Object)this.getFluid()));
            buf.method_10791(this.getAmount());
            class_9326.field_49590.encode((Object)buf, (Object)this.getComponents());
        }
    }

    protected void readWithoutUnit(class_9129 buf) {
        if (buf.readBoolean()) {
            this.setFluid((class_3611)class_7923.field_41173.method_10200(buf.method_10816()));
            this.setAmount(buf.method_10792());
            this.setComponents((class_9326)class_9326.field_49590.decode((Object)buf));
        } else {
            this.setFluid(class_3612.field_15906);
            this.setAmount(0L);
            this.setComponents(class_9326.field_49588);
        }
    }

    public FluidVolume createSnapshot() {
        return new FluidVolume(this.getFluid(), this.getAmount(), this.getComponents(), this.getUnit());
    }

    public void increment(long amount, FluidUnit unit) {
        this.setAmount(this.getAmount() + FluidUnit.convert(amount, unit, this.getUnit()));
    }

    public void decrement(long amount, FluidUnit unit) {
        this.increment(-amount, unit);
    }

    public boolean matches(FluidIngredient ingredient) {
        return ingredient.fluid().matches(this.getFluid()) && FluidUnit.compareVolumes(this, ingredient) >= 0 && Objects.equals(this.getComponents(), ingredient.components());
    }

    public class_2561 getAmountText() {
        FluidUnit displayUnit = FluidReference.getDefaultDisplayUnit();
        return class_2561.method_43469((String)"gui.adorn.fluid_volume", (Object[])new Object[]{FluidUnit.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.getUnitDenominator(this.getUnit(), displayUnit)), displayUnit.getSymbol()});
    }

    public class_2561 getAmountText(long max, FluidUnit maxUnit) {
        FluidUnit displayUnit = FluidReference.getDefaultDisplayUnit();
        return class_2561.method_43469((String)"gui.adorn.fluid_volume.fraction", (Object[])new Object[]{FluidUnit.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.getUnitDenominator(this.getUnit(), displayUnit)).toString(), FluidUnit.losslessConvert(max, maxUnit, displayUnit).resizeFraction(FluidReference.getUnitDenominator(maxUnit, displayUnit)).toString(), displayUnit.getSymbol()});
    }

    private static FluidUnit getDefaultDisplayUnit() {
        return ConfigManager.config().client.displayedFluidUnit;
    }

    private static long getUnitDenominator(FluidUnit from, FluidUnit to) {
        if (from.getBucketVolume() == to.getBucketVolume()) {
            return 1L;
        }
        return Math.max(1L, from.getBucketVolume() / to.getBucketVolume());
    }

    public String toString() {
        return "FluidReference(fluid=%s, amount=%d, nbt=%s)".formatted(class_7923.field_41173.method_10221((Object)this.getFluid()), this.getAmount(), this.getComponents());
    }

    public static boolean areFluidsEqual(FluidReference a, FluidReference b) {
        if (a.isEmpty()) {
            return b.isEmpty();
        }
        return a.getFluid() == b.getFluid() && Objects.equals(a.getComponents(), b.getComponents());
    }

    public static boolean areFluidsAndAmountsEqual(FluidReference a, FluidReference b) {
        if (a.isEmpty()) {
            return b.isEmpty();
        }
        return FluidReference.areFluidsEqual(a, b) && FluidUnit.compareVolumes(a, b) == 0;
    }
}

