/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.menu;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.entity.TradingStation;
import juuxel.adorn.menu.AdornMenus;
import juuxel.adorn.trading.TradeInventory;
import juuxel.adorn.util.InventoryComponent;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3914;
import net.minecraft.class_3917;

public final class TradingStationMenu
extends class_1703 {
    private final class_3914 context;
    private final TradingStation tradingStation;
    private final class_1735 sellingSlot;
    private final class_1735 priceSlot;

    public TradingStationMenu(int syncId, class_1661 playerInventory, class_3914 context) {
        super((class_3917)AdornMenus.TRADING_STATION.get(), syncId);
        int x;
        int y;
        this.context = context;
        int slot = 18;
        this.tradingStation = TradingStationMenu.getTradingStation(context);
        TradeInventory tradeInventory = this.tradingStation.getTrade().createInventory();
        InventoryComponent storage = this.tradingStation.getStorage();
        this.sellingSlot = this.method_7621(new TradeSlot(tradeInventory, 0, 26, 36));
        this.priceSlot = this.method_7621(new TradeSlot(tradeInventory, 1, 26, 72));
        for (y = 0; y <= 2; ++y) {
            for (x = 0; x <= 3; ++x) {
                this.method_7621(new StorageSlot(storage, x + y * 4, 62 + x * slot, 36 + y * slot));
            }
        }
        for (y = 0; y <= 2; ++y) {
            for (x = 0; x <= 8; ++x) {
                this.method_7621(new class_1735((class_1263)playerInventory, x + y * 9 + 9, 8 + x * slot, 104 + y * slot));
            }
        }
        for (int x2 = 0; x2 <= 8; ++x2) {
            this.method_7621(new class_1735((class_1263)playerInventory, x2, 8 + x2 * slot, 162));
        }
    }

    public TradingStationMenu(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    private static TradingStation getTradingStation(class_3914 context) {
        return context.method_17395((world, pos) -> world.method_35230(pos, (class_2591)AdornBlockEntities.TRADING_STATION.get())).flatMap(tradingStation -> tradingStation).orElseGet(TradingStation::createEmpty);
    }

    public static boolean isValidItem(class_1799 stack) {
        return stack.method_7909().method_31568();
    }

    public class_1735 getSellingSlot() {
        return this.sellingSlot;
    }

    public class_1735 getPriceSlot() {
        return this.priceSlot;
    }

    public boolean method_7597(class_1657 player) {
        return TradingStationMenu.method_17695((class_3914)this.context, (class_1657)player, (class_2248)((class_2248)AdornBlocks.TRADING_STATION.get()));
    }

    public class_1799 method_7601(class_1657 player, int index) {
        int offset = 2;
        if (index < offset) {
            return class_1799.field_8037;
        }
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            int containerSize = 12;
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if (offset <= index && index < containerSize + offset ? !this.method_7616(stack, containerSize + offset, this.field_7761.size(), true) : !this.method_7616(stack, offset, containerSize + offset, false)) {
                return class_1799.field_8037;
            }
            if (stack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return result;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        class_1735 slot;
        class_1735 class_17352 = slot = 0 <= slotIndex && slotIndex < this.field_7761.size() ? (class_1735)this.field_7761.get(slotIndex) : null;
        if (actionType == class_1713.field_7790 && slot instanceof TradeSlot) {
            TradeSlot tradeSlot = (TradeSlot)slot;
            class_1799 cursorStack = this.method_34255();
            if (TradingStationMenu.isValidItem(cursorStack)) {
                this.updateTradeStack(tradeSlot, cursorStack.method_7972(), player);
            }
        } else {
            super.method_7593(slotIndex, button, actionType, player);
        }
    }

    public void updateTradeStack(int slotId, class_1799 stack, class_1657 player) {
        class_1735 class_17352 = this.method_7611(slotId);
        if (class_17352 instanceof TradeSlot) {
            TradeSlot slot = (TradeSlot)class_17352;
            this.updateTradeStack(slot, stack, player);
        }
    }

    private void updateTradeStack(TradeSlot slot, class_1799 stack, class_1657 player) {
        slot.method_53512(stack);
        slot.method_7668();
        TradingStation tradingStation = this.tradingStation;
        if (tradingStation instanceof class_2586) {
            class_2586 be = (class_2586)tradingStation;
            class_2680 state = be.method_11010();
            player.method_37908().method_8413(be.method_11016(), state, state, 2);
        }
    }

    private static final class TradeSlot
    extends class_1735 {
        private TradeSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public class_1799 method_7671(int amount) {
            return class_1799.field_8037;
        }
    }

    private static final class StorageSlot
    extends class_1735 {
        private StorageSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return TradingStationMenu.isValidItem(stack);
        }
    }
}

