/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.tooltips;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class MuteTooltipSupplier
implements ImageButton.TooltipSupplier {
    public static final class_2561 MUTE_UNMUTED = class_2561.method_43471((String)"message.voicechat.mute.disabled");
    public static final class_2561 MUTE_MUTED = class_2561.method_43471((String)"message.voicechat.mute.enabled");
    public static final class_2561 MUTE_DISABLED_PTT = class_2561.method_43471((String)"message.voicechat.mute.disabled_ptt");
    private class_437 screen;
    private ClientPlayerStateManager stateManager;
    @Nullable
    private State lastState;

    public MuteTooltipSupplier(class_437 screen, ClientPlayerStateManager stateManager) {
        this.screen = screen;
        this.stateManager = stateManager;
    }

    @Override
    public void updateTooltip(ImageButton button) {
        State state = this.getState();
        if (state != this.lastState) {
            this.lastState = state;
            button.method_47400(class_7919.method_47407((class_2561)state.getComponent()));
        }
    }

    public static boolean canMuteMic() {
        return VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
    }

    private State getState() {
        if (!MuteTooltipSupplier.canMuteMic()) {
            return State.DISABLED_PTT;
        }
        if (this.stateManager.isMuted()) {
            return State.MUTED;
        }
        return State.UNMUTED;
    }

    private static enum State {
        UNMUTED(MUTE_UNMUTED),
        MUTED(MUTE_MUTED),
        DISABLED_PTT(MUTE_DISABLED_PTT);

        private final class_2561 component;

        private State(class_2561 component) {
            this.component = component;
        }

        public class_2561 getComponent() {
            return this.component;
        }
    }
}

